/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.util;

import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.transaction.Transaction;
import org.jboss.seam.transaction.UserTransaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Work<T> {
    private static final LogProvider log = Logging.getLogProvider(Work.class);

    protected abstract T work() throws Exception;

    protected boolean isNewTransactionRequired(boolean transactionActive) {
        return !transactionActive;
    }

    public final T workInTransaction() throws Exception {
        UserTransaction userTransaction;
        boolean transactionActive = Transaction.instance().isActiveOrMarkedRollback() || Transaction.instance().isRolledBack();
        boolean begin = this.isNewTransactionRequired(transactionActive);
        UserTransaction userTransaction2 = userTransaction = begin ? Transaction.instance() : null;
        if (begin) {
            log.debug("beginning transaction");
            userTransaction.begin();
        }
        try {
            T result = this.work();
            if (begin) {
                log.debug("committing transaction");
                userTransaction.commit();
            }
            return result;
        }
        catch (Exception e) {
            if (begin && userTransaction.getStatus() != 6) {
                log.debug("rolling back transaction");
                userTransaction.rollback();
            }
            throw e;
        }
    }
}

