/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.rest.example.tasks.db;

import java.util.Date;
import java.util.LinkedList;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.jboss.logging.Logger;
import org.jboss.seam.rest.example.tasks.entity.Category;
import org.jboss.seam.rest.example.tasks.entity.Task;

@Stateless
public class ImportBean {
    public static final Logger log = Logger.getLogger(ImportBean.class);
    @PersistenceContext
    private EntityManager em;

    public void clearDatabase() {
        this.em.createQuery("delete from Task").executeUpdate();
        this.em.createQuery("delete from Category").executeUpdate();
    }

    public void feedDatabase() {
        log.info((Object)"Running database import.");
        Category school = this.createCategory("School");
        this.addTask(school, "Build the Turing machine");
        this.addTask(school, "Finish the RESTEasy-Seam integration example");
        this.addTask(school, "Learn new vocab for English conversations");
        this.addTask(school, "Prepare a presentation for webdesign seminar");
        this.addTask(school, "Print study materials", true);
        this.em.persist((Object)school);
        Category work = this.createCategory("Work");
        this.addTask(work, "Pick up meal tickets");
        this.em.persist((Object)work);
        Category buy = this.createCategory("Buy");
        this.addTask(buy, "Buy milk");
        this.addTask(buy, "Buy an infinite tape");
        this.addTask(buy, "Order books");
        this.addTask(buy, "Buy a turtle", true);
        this.addTask(buy, "Buy new shoes", true);
        this.addTask(buy, "Order camera", true);
        this.em.persist((Object)buy);
        Category other_stuff = this.createCategory("Other Stuff");
        this.addTask(other_stuff, "Learn to fly", true);
        this.addTask(other_stuff, "Visit grandma");
        this.addTask(other_stuff, "Extend passport");
        this.addTask(other_stuff, "Get a haircut");
        this.addTask(other_stuff, "Pay bills", true);
        this.addTask(other_stuff, "Tidy up", true);
        this.em.persist((Object)other_stuff);
    }

    private Category createCategory(String name) {
        Category c = new Category(name);
        c.setTasks(new LinkedList());
        return c;
    }

    private void addTask(Category category, String name) {
        this.addTask(category, name, false);
    }

    private void addTask(Category category, String name, boolean resolved) {
        Task task = new Task(name, Boolean.valueOf(resolved), new Date(), new Date(), category);
        category.getTasks().add(task);
    }
}

