/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.rest.example.tasks.resource;

import java.net.URI;
import java.util.Date;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.seam.rest.example.tasks.entity.Category;
import org.jboss.seam.rest.example.tasks.entity.JaxbTaskWrapper;
import org.jboss.seam.rest.example.tasks.entity.Task;
import org.jboss.seam.rest.example.tasks.entity.TaskValidationGroup;
import org.jboss.seam.rest.example.tasks.resource.AbstractEntityResource;
import org.jboss.seam.rest.example.tasks.resource.TaskCollectionResource;
import org.jboss.seam.rest.validation.ValidateRequest;

@Path(value="/category/{category}")
@Produces(value={"application/xml", "application/json"})
@Consumes(value={"application/xml", "application/json"})
@ValidateRequest(groups={TaskValidationGroup.class})
@Stateless
public class CategoryResource
extends AbstractEntityResource {
    @Inject
    private TaskCollectionResource taskCollectionSubresource;

    @Path(value="/")
    public TaskCollectionResource getTasks() {
        return this.taskCollectionSubresource;
    }

    @PUT
    public void putCategory(@PathParam(value="category") String categoryName) {
        Category category = new Category(categoryName);
        this.em.persist((Object)category);
    }

    @DELETE
    public void deleteCategory(@PathParam(value="category") String categoryName) {
        this.em.remove((Object)this.loadCategory(categoryName));
    }

    @POST
    @Path(value="/task")
    public Response createTask(JaxbTaskWrapper incommingTask, @PathParam(value="category") String categoryName, @Context UriInfo uriInfo) {
        Category category = this.loadCategory(categoryName);
        Task task = new Task();
        task.setCategory(category);
        task.setCreated(new Date());
        task.setUpdated(task.getCreated());
        task.setName(incommingTask.getName());
        task.setResolved(Boolean.valueOf(false));
        this.em.persist((Object)task);
        long id = task.getId();
        URI uri = uriInfo.getBaseUriBuilder().path(TaskCollectionResource.class).path(TaskCollectionResource.class, "getTaskSubresource").build(new Object[]{String.valueOf(id)});
        return Response.created((URI)uri).build();
    }
}

