/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.solder.config.xml.parser.namespace;

import java.lang.constant.Constable;
import org.jboss.solder.config.xml.model.ArrayXmlItem;
import org.jboss.solder.config.xml.model.ClassXmlItem;
import org.jboss.solder.config.xml.model.EntryXmlItem;
import org.jboss.solder.config.xml.model.KeyXmlItem;
import org.jboss.solder.config.xml.model.ModifiesXmlItem;
import org.jboss.solder.config.xml.model.ParameterXmlItem;
import org.jboss.solder.config.xml.model.ParametersXmlItem;
import org.jboss.solder.config.xml.model.ReplacesXmlItem;
import org.jboss.solder.config.xml.model.ValueXmlItem;
import org.jboss.solder.config.xml.model.XmlItem;
import org.jboss.solder.config.xml.model.XmlItemType;
import org.jboss.solder.config.xml.parser.SaxNode;
import org.jboss.solder.config.xml.parser.namespace.CompositeNamespaceElementResolver;
import org.jboss.solder.config.xml.parser.namespace.NamespaceElementResolver;

public class RootNamespaceElementResolver
implements NamespaceElementResolver {
    private final CompositeNamespaceElementResolver delegate = new CompositeNamespaceElementResolver(namspaces);
    static final String[] namspaces = new String[]{"java.lang", "java.util", "javax.annotation", "javax.inject", "javax.enterprise.inject", "javax.enterprise.context", "javax.enterprise.event", "javax.decorator", "javax.interceptor", "org.jboss.seam.config.xml.annotations.internal", "org.jboss.solder.core", "org.jboss.solder.unwraps", "org.jboss.solder.resourceLoader"};

    @Override
    public XmlItem getItemForNamespace(SaxNode node, XmlItem parent) {
        XmlItem ret = this.getRootItem(node, parent);
        if (ret != null) {
            return ret;
        }
        return this.delegate.getItemForNamespace(node, parent);
    }

    XmlItem getRootItem(SaxNode node, XmlItem parent) {
        String item = node.getName();
        if (item.equals(XmlItemType.VALUE.getElementName()) || item.equals(XmlItemType.VALUE.getAlias())) {
            return new ValueXmlItem(parent, node.getInnerText(), node.getDocument(), node.getLineNo());
        }
        if (item.equals(XmlItemType.KEY.getElementName()) || item.equals(XmlItemType.KEY.getAlias())) {
            return new KeyXmlItem(parent, node.getInnerText(), node.getDocument(), node.getLineNo());
        }
        if (item.equals(XmlItemType.ENTRY.getElementName()) || item.equals(XmlItemType.ENTRY.getAlias())) {
            return new EntryXmlItem(parent, node.getDocument(), node.getLineNo());
        }
        if (item.equals(XmlItemType.ARRAY.getElementName())) {
            return new ArrayXmlItem(parent, node.getAttributes(), node.getDocument(), node.getLineNo());
        }
        if (item.equals(XmlItemType.REPLACE.getElementName())) {
            return new ReplacesXmlItem(parent, node.getDocument(), node.getLineNo());
        }
        if (item.equals(XmlItemType.MODIFIES.getElementName())) {
            return new ModifiesXmlItem(parent, node.getDocument(), node.getLineNo());
        }
        if (item.equals(XmlItemType.PARAMETERS.getElementName())) {
            return new ParametersXmlItem(parent, node.getDocument(), node.getLineNo());
        }
        Class<Constable> primType = null;
        if (item.equals("int")) {
            primType = Integer.TYPE;
        } else if (item.equals("short")) {
            primType = Short.TYPE;
        } else if (item.equals("long")) {
            primType = Long.TYPE;
        } else if (item.equals("byte")) {
            primType = Byte.TYPE;
        } else if (item.equals("char")) {
            primType = Character.TYPE;
        } else if (item.equals("double")) {
            primType = Double.TYPE;
        } else if (item.equals("float")) {
            primType = Float.TYPE;
        } else if (item.equals("boolean")) {
            primType = Boolean.TYPE;
        }
        if (primType != null) {
            if (parent != null && parent.getType() == XmlItemType.PARAMETERS) {
                return new ParameterXmlItem(parent, primType, node.getDocument(), node.getLineNo());
            }
            return new ClassXmlItem(parent, primType, node.getAttributes(), node.getDocument(), node.getLineNo());
        }
        return null;
    }
}

