/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.solder.exception.control.extension;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.InjectionException;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.Interceptor;
import javax.enterprise.inject.spi.ProcessBean;
import org.jboss.solder.exception.control.ExceptionHandlerComparator;
import org.jboss.solder.exception.control.HandlerMethod;
import org.jboss.solder.exception.control.HandlerMethodContainer;
import org.jboss.solder.exception.control.HandlerMethodImpl;
import org.jboss.solder.exception.control.HandlesExceptions;
import org.jboss.solder.exception.control.TraversalMode;
import org.jboss.solder.literal.AnyLiteral;
import org.jboss.solder.reflection.AnnotationInspector;
import org.jboss.solder.reflection.HierarchyDiscovery;

public class CatchExtension
implements Extension,
HandlerMethodContainer {
    private final Map<? super Type, Collection<HandlerMethod<? extends Throwable>>> allHandlers = new HashMap<Type, Collection<HandlerMethod<? extends Throwable>>>();

    public <T> void findHandlers(@Observes ProcessBean<?> pmb, BeanManager bm) {
        if (!(pmb.getAnnotated() instanceof AnnotatedType) || pmb.getBean() instanceof Interceptor || pmb.getBean() instanceof Decorator) {
            return;
        }
        AnnotatedType type = (AnnotatedType)pmb.getAnnotated();
        if (AnnotationInspector.isAnnotationPresent((Annotated)type, HandlesExceptions.class, (BeanManager)bm)) {
            Set methods = type.getMethods();
            for (AnnotatedMethod method : methods) {
                if (!HandlerMethodImpl.isHandler(method)) continue;
                AnnotatedParameter<?> param = HandlerMethodImpl.findHandlerParameter(method);
                if (method.getJavaMember().getExceptionTypes().length != 0) {
                    pmb.addDefinitionError((Throwable)new IllegalArgumentException(String.format("Handler method %s must not throw exceptions", method.getJavaMember())));
                }
                Class exceptionType = (Class)((ParameterizedType)param.getBaseType()).getActualTypeArguments()[0];
                this.registerHandlerMethod(new HandlerMethodImpl(method, bm));
            }
        }
    }

    public void verifyInjectionPoints(@Observes AfterDeploymentValidation adv, BeanManager bm) {
        for (Map.Entry<? super Type, Collection<HandlerMethod<? extends Throwable>>> entry : this.allHandlers.entrySet()) {
            for (HandlerMethod<? extends Throwable> handler : entry.getValue()) {
                for (InjectionPoint ip : ((HandlerMethodImpl)handler).getInjectionPoints()) {
                    try {
                        bm.validate(ip);
                    }
                    catch (InjectionException e) {
                        adv.addDeploymentProblem((Throwable)e);
                    }
                }
            }
        }
    }

    public Collection<HandlerMethod<? extends Throwable>> getHandlersForExceptionType(Type exceptionClass, BeanManager bm, Set<Annotation> handlerQualifiers, TraversalMode traversalMode) {
        TreeSet<HandlerMethod<? extends Throwable>> returningHandlers = new TreeSet<HandlerMethod<? extends Throwable>>(new ExceptionHandlerComparator());
        HierarchyDiscovery h = new HierarchyDiscovery(exceptionClass);
        Set closure = h.getTypeClosure();
        for (Type hierarchyType : closure) {
            if (this.allHandlers.get(hierarchyType) == null) continue;
            for (HandlerMethod<? extends Throwable> handler : this.allHandlers.get(hierarchyType)) {
                if (handler.getTraversalMode() != traversalMode) continue;
                if (handler.getQualifiers().contains(AnyLiteral.INSTANCE)) {
                    returningHandlers.add(handler);
                    continue;
                }
                if (handlerQualifiers.isEmpty() || !this.containsAny(handler.getQualifiers(), handlerQualifiers)) continue;
                returningHandlers.add(handler);
            }
        }
        return Collections.unmodifiableCollection(returningHandlers);
    }

    private boolean containsAny(Collection<? extends Annotation> haystack, Collection<? extends Annotation> needles) {
        for (Annotation annotation : needles) {
            if (!haystack.contains(annotation)) continue;
            return true;
        }
        return false;
    }

    public <T extends Throwable> void registerHandlerMethod(HandlerMethod<T> handlerMethod) {
        if (this.allHandlers.containsKey(handlerMethod.getExceptionType())) {
            this.allHandlers.get(handlerMethod.getExceptionType()).add(handlerMethod);
        } else {
            this.allHandlers.put(handlerMethod.getExceptionType(), new HashSet<HandlerMethod>(Arrays.asList(handlerMethod)));
        }
    }
}

