/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.solder.servlet.http;

import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.jboss.solder.reflection.PrimitiveTypes;
import org.jboss.solder.servlet.ServletExtension;
import org.jboss.solder.servlet.http.DefaultValue;
import org.jboss.solder.servlet.http.RequestParam;
import org.jboss.solder.servlet.http.TypedParamValue;

public class RequestParamProducer {
    @Inject
    private HttpServletRequest request;

    @Produces
    @TypedParamValue
    protected Object getTypedParamValue(InjectionPoint ip, ServletExtension ext) {
        String v = this.getParameterValue(this.getParameterName(ip), ip);
        Class t = PrimitiveTypes.box(this.resolveExpectedType(ip));
        if (t.equals(String.class)) {
            return v;
        }
        try {
            Member converter = ext.getConverterMember(t);
            return converter instanceof Constructor ? ((Constructor)converter).newInstance(v) : ((Method)converter).invoke(null, v);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getParameterName(InjectionPoint ip) {
        String parameterName = ((RequestParam)ip.getAnnotated().getAnnotation(RequestParam.class)).value();
        if ("".equals(parameterName)) {
            parameterName = ip.getMember().getName();
        }
        return parameterName;
    }

    private String getParameterValue(String parameterName, InjectionPoint ip) {
        return this.isParameterInRequest(parameterName) ? this.request.getParameter(parameterName) : this.getDefaultValue(ip);
    }

    private boolean isParameterInRequest(String parameterName) {
        return this.request.getParameterMap().containsKey(parameterName);
    }

    private String getDefaultValue(InjectionPoint ip) {
        DefaultValue defaultValueAnnotation = (DefaultValue)ip.getAnnotated().getAnnotation(DefaultValue.class);
        return defaultValueAnnotation == null ? null : defaultValueAnnotation.value();
    }

    private Class<?> resolveExpectedType(InjectionPoint ip) {
        Type t = ip.getType();
        if (t instanceof ParameterizedType && ((ParameterizedType)t).getActualTypeArguments().length == 1) {
            return (Class)((ParameterizedType)t).getActualTypeArguments()[0];
        }
        if (t instanceof Class) {
            return (Class)t;
        }
        return Object.class;
    }
}

