/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.solder.servlet.support;

import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.jboss.solder.logging.Log;
import org.jboss.solder.logging.Logger;
import org.jboss.solder.logging.MessageLogger;
import org.jboss.solder.messages.Message;

@MessageLogger
public interface ServletLogger {
    public static final String CATEGORY = "seam-servlet";

    @Log(level=Logger.Level.TRACE)
    @Message(value="Servlet context initialized: %s")
    public void servletContextInitialized(ServletContext var1);

    @Log(level=Logger.Level.TRACE)
    @Message(value="Servlet context destroyed: %s")
    public void servletContextDestroyed(ServletContext var1);

    @Log(level=Logger.Level.TRACE)
    @Message(value="Servlet request initialized: %s")
    public void servletRequestInitialized(ServletRequest var1);

    @Log(level=Logger.Level.TRACE)
    @Message(value="Servlet request destroyed: %s")
    public void servletRequestDestroyed(ServletRequest var1);

    @Log(level=Logger.Level.TRACE)
    @Message(value="Servlet response initialized: %s")
    public void servletResponseInitialized(ServletResponse var1);

    @Log(level=Logger.Level.TRACE)
    @Message(value="Servlet response destroyed: %s")
    public void servletResponseDestroyed(ServletResponse var1);

    @Log(level=Logger.Level.INFO)
    @Message(value="CDI BeanManager cannot be found. Not sending event %s with qualifiers %s")
    public void skippingEventNoBeanManager(Object var1, List var2);

    @Log(level=Logger.Level.INFO)
    @Message(value="Catch Integration for Servlets enabled")
    public void catchIntegrationEnabled();

    @Log(level=Logger.Level.INFO)
    @Message(value="Could not locate CDI BeanManager. Catch Integration for Servlets disabled")
    public void catchIntegrationDisabledNoBeanManager();
}

