package org.jboss.threads;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.SecurityException;
import java.lang.String;
import org.jboss.threads.StoppedExecutorException;
import org.jboss.logging.Logger;
import org.jboss.threads.InterruptHandler;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-09-13T08:15:44-0500")
public class Messages_$logger extends DelegatingBasicLogger implements Messages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Messages_$logger.class.getName();
    public Messages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void version(final String version) {
        super.log.logf(FQCN, INFO, null, version$str(), version);
    }
    private static final String version = "JBoss Threads version %s";
    protected String version$str() {
        return version;
    }
    private static final String shutDownInitiated = "JBTHR00009: Executor has been shut down";
    protected String shutDownInitiated$str() {
        return shutDownInitiated;
    }
    @Override
    public final org.jboss.threads.StoppedExecutorException shutDownInitiated() {
        final org.jboss.threads.StoppedExecutorException result = new org.jboss.threads.StoppedExecutorException(String.format(getLoggingLocale(), shutDownInitiated$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotAwaitWithin = "JBTHR00012: Cannot await termination of a thread pool from one of its own threads";
    protected String cannotAwaitWithin$str() {
        return cannotAwaitWithin;
    }
    @Override
    public final IllegalStateException cannotAwaitWithin() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotAwaitWithin$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noInterruptHandlers = "JBTHR00103: The current thread does not support interrupt handlers";
    protected String noInterruptHandlers$str() {
        return noInterruptHandlers;
    }
    @Override
    public final IllegalStateException noInterruptHandlers() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noInterruptHandlers$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String notShutDown = "JBTHR00104: Executor is not shut down";
    protected String notShutDown$str() {
        return notShutDown;
    }
    @Override
    public final IllegalStateException notShutDown() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), notShutDown$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void interruptHandlerThrew(final Throwable cause, final org.jboss.threads.InterruptHandler interruptHandler) {
        super.log.logf(FQCN, ERROR, cause, interruptHandlerThrew$str(), interruptHandler);
    }
    private static final String interruptHandlerThrew = "JBTHR00108: Interrupt handler %s threw an exception";
    protected String interruptHandlerThrew$str() {
        return interruptHandlerThrew;
    }
    private static final String notAllowedContainerManaged = "JBTHR00200: %s() not allowed on container-managed executor";
    protected String notAllowedContainerManaged$str() {
        return notAllowedContainerManaged;
    }
    @Override
    public final SecurityException notAllowedContainerManaged(final String methodName) {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), notAllowedContainerManaged$str(), methodName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
