/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.tycho.sitegenerator;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(defaultPhase=LifecyclePhase.PACKAGE, name="generate-discovery-site")
public class GenerateDirectoryXmlMojo
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.directory}/discovery-site/")
    private File outputDirectory;
    @Parameter
    private String discoveryFileName;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!"eclipse-repository".equals(this.project.getPackaging())) {
            return;
        }
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        File repositoryPluginsFolder = new File(this.project.getBuild().getDirectory(), "repository/plugins");
        File discoveryPluginsFolder = new File(this.outputDirectory, "plugins");
        StringBuilder directoryXml = new StringBuilder();
        directoryXml.append("<?xml version='1.0' encoding='UTF-8'?>\n");
        directoryXml.append("<directory xmlns='http://www.eclipse.org/mylyn/discovery/directory/'>\n");
        for (File plugin : repositoryPluginsFolder.listFiles()) {
            directoryXml.append("  <entry url='plugins/");
            directoryXml.append(plugin.getName());
            directoryXml.append("' permitCategories='true'/>");
            directoryXml.append('\n');
            try {
                FileUtils.copyFileToDirectory((File)plugin, (File)discoveryPluginsFolder);
            }
            catch (Exception ex) {
                throw new MojoFailureException(ex.getMessage(), (Throwable)ex);
            }
        }
        directoryXml.append("</directory>");
        if (this.discoveryFileName == null) {
            this.discoveryFileName = this.project.getArtifactId() + ".xml";
        }
        try {
            FileUtils.writeStringToFile((File)new File(this.outputDirectory, this.discoveryFileName), (String)directoryXml.toString());
        }
        catch (Exception ex) {
            throw new MojoFailureException(ex.getMessage(), (Throwable)ex);
        }
    }
}

