/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.unit.api.pojo.junit;

import org.jboss.unit.spi.pojo.TestSuiteDescriptor;
import org.jboss.unit.spi.pojo.ParameterDescriptor;
import org.jboss.unit.spi.pojo.TestCaseDescriptor;

import java.util.Map;
import java.util.Set;
import java.util.Collections;
import java.util.HashMap;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

/**
 * @author <a href="mailto:julien@jboss.org">Julien Viet</a>
 * @version $Revision: 1.1 $
 */
class JUnitDescriptor implements TestSuiteDescriptor
{

   /** . */
   final Class testClass;

   /** . */
   final Map<String,JUnitTestMethod> testMap;

   public JUnitDescriptor(JUnitProvider provider)
   {
      this.testClass = provider.testClass;
      this.testMap = new HashMap<String, JUnitTestMethod>();

      //
      try
      {
         Method[] methods = testClass.getMethods();
         for (int j = 0; j < methods.length; j++)
         {
            Method method = methods[j];

            //
            int modifiers = method.getModifiers();
            if (Modifier.isPublic(modifiers) && !Modifier.isAbstract(modifiers) && !Modifier.isStatic(modifiers))
            {
               String methodName = method.getName();
               if (methodName.startsWith("test") &&
                  method.getParameterTypes().length == 0)
               {
                  JUnitTestMethod tm = new JUnitTestMethod(method);
                  testMap.put(method.getName(), tm);
               }
//               else if (methodName.startsWith("set") &&
//                  methodName.endsWith("Parameter") &&
//                  method.getParameterTypes().length == 1)
//               {
//                  String parameterName = methodName.substring(3, methodName.length() - 9);
//                  setterMap.put(parameterName, method);
//               }
            }
         }

         // Set all parameters on children
//         for (Iterator i = setterMap.keySet().iterator(); i.hasNext();)
//         {
//            String parameterName = (String)i.next();
//            for (Iterator j = testMap.keySet().iterator(); j.hasNext();)
//            {
//               String childName = (String)j.next();
//               TestInfo childInfo = (TestInfo)containerInfo.getChild(childName);
//               childInfo.addParameter(new TestParameterInfo(parameterName));
//            }
//         }
      }
      catch (Exception e)
      {
         IllegalArgumentException iae = new IllegalArgumentException();
         iae.initCause(e);
         throw iae;
      }
   }

   public String getName()
   {
      return testClass.getName();
   }

   public String getDescription()
   {
      return "";
   }

   public Set<String> getKeywords()
   {
      return Collections.emptySet();
   }

   public Map<String, ? extends ParameterDescriptor> getParameters()
   {
      return Collections.emptyMap();
   }

   public Map<String, ? extends TestCaseDescriptor> getTestCases()
   {
      return Collections.unmodifiableMap(testMap);
   }
}
