/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.unit.driver;

import org.jboss.unit.TestId;
import org.jboss.unit.info.TestInfo;

/**
 * Defines what a test driver is.
 *
 * @author <a href="mailto:julien@jboss.org">Julien Viet</a>
 * @version $Revision: 1.1 $
 */
public interface TestDriver
{

   /**
    * Initialize the test driver.
    *
    * @param context the driver context
    * @throws DriverException if anything occurs that would prevent the initialization of the driver
    */
   void initDriver(DriverContext context) throws DriverException;

   /**
    * Destroy the test driver.
    */
   void destroyDriver();

   /**
    * Return a runtime meta data about this test driver.
    * 
    * @return the description
    */
   TestInfo getInfo();

   /**
    * Execute a command of the testing protocol.
    *
    * @param id the test case id relative to this driver
    * @param command the command to execute
    * @return the response the response to the command
    */
   DriverResponse invoke(TestId id, DriverCommand command); 
}
