/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.unit.driver.impl.composite;

import org.jboss.unit.Failure;
import org.jboss.unit.TestId;
import org.jboss.unit.driver.AbstractTestDriver;
import org.jboss.unit.driver.DriverCommand;
import org.jboss.unit.driver.DriverResponse;
import org.jboss.unit.driver.TestDriver;
import org.jboss.unit.driver.response.FailureResponse;
import org.jboss.unit.info.TestInfo;
import org.jboss.unit.info.impl.SimpleTestSuiteInfo;
import org.jboss.unit.info.impl.SimpleTestInfo;

import java.util.Set;

/**
 * @author <a href="mailto:julien@jboss.org">Julien Viet</a>
 * @version $Revision: 1.1 $
 */
public abstract class AbstractCompositeTestDriver extends AbstractTestDriver
{

   public TestInfo getInfo()
   {
      SimpleTestSuiteInfo info = new SimpleTestSuiteInfo(getName());

      //
      for (String name : getNames())
      {
         TestDriver driver = getDriver(name);
         info.addTest(SimpleTestInfo.create(driver.getInfo()));
      }

      return info;
   }

   public DriverResponse invoke(TestId id, DriverCommand command)
   {
      if (id.getLength() == 0)
      {
         return new FailureResponse(Failure.createErrorFailure("No null test id accepted"));
      }

      //
      String name = id.getName(0);

      //
      TestDriver driver = getDriver(name);

      //
      if (driver == null)
      {
         return new FailureResponse(Failure.createErrorFailure("No test driver found for name " + name));
      }

      //
      TestId driverId = id.range(1);

      //
      return driver.invoke(driverId, command);
   }

   public abstract String getName();

   public abstract TestDriver getDriver(String name);

   public abstract Set<String> getNames();

}