/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.unit.driver.impl.composite;

import org.jboss.unit.driver.TestDriver;
import org.jboss.unit.driver.DriverException;

import java.util.Map;
import java.util.HashMap;
import java.util.Set;

/**
 * @author <a href="mailto:julien@jboss.org">Julien Viet</a>
 * @version $Revision: 1.1 $
 */
public class CompositeTestDriver extends AbstractCompositeTestDriver
{

   /** . */
   private final String name;

   /** . */
   protected final Map<String, TestDriver> drivers = new HashMap<String, TestDriver>();

   public CompositeTestDriver()
   {
      this("Main");
   }

   public CompositeTestDriver(String name)
   {
      this.name = name;
   }

   public String getName()
   {
      return name;
   }

   public TestDriver getDriver(String name)
   {
      return drivers.get(name);
   }

   public Set<String> getNames()
   {
      return drivers.keySet();
   }

   public void mount(TestDriver driver) throws DriverException
   {
      synchronized(TestDriver.class)
      {
         driver.initDriver(getContext());

         //
         String name = driver.getInfo().getName();

         //
         drivers.put(name, driver);
      }
   }

   public synchronized void unmount(TestDriver driver)
   {
      synchronized(TestDriver.class)
      {
         String name = driver.getInfo().getName();

         //
         drivers.remove(name);

         //
         driver.destroyDriver();
      }
   }
}
