/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.unit.driver.impl.pojo;

import org.jboss.unit.spi.pojo.TestCaseDescriptor;
import org.jboss.unit.spi.pojo.TestSuiteDescriptor;
import org.jboss.unit.info.TestSuiteInfo;
import org.jboss.unit.info.TestInfo;
import org.jboss.unit.TestId;

import java.util.Set;
import java.util.Map;
import java.util.HashMap;

/**
 * @author <a href="mailto:julien@jboss.org">Julien Viet</a>
 * @version $Revision: 1.1 $
 */
public class POJOTestSuiteInfo extends POJOTestInfo implements TestSuiteInfo
{

   /** . */
   private TestSuiteDescriptor descriptor;

   /** . */
   private Map<String,POJOTestCaseInfo> testCases;

   public POJOTestSuiteInfo(TestSuiteDescriptor descriptor)
   {
      super(descriptor.getParameters(), descriptor.getKeywords());

      //
      HashMap<String, POJOTestCaseInfo> testCases = new HashMap<String, POJOTestCaseInfo>();
      for (TestCaseDescriptor testCaseDescriptor : descriptor.getTestCases().values())
      {
         POJOTestCaseInfo testCase = new POJOTestCaseInfo(testCaseDescriptor);
         testCases.put(testCase.getName(), testCase);
      }

      //
      this.descriptor = descriptor;
      this.testCases = testCases;
   }

   public String getName()
   {
      return descriptor.getName();
   }

   public String getDescription()
   {
      return descriptor.getDescription();
   }

   public TestInfo getTest(String name)
   {
      return testCases.get(name);
   }

   public Set<String> getNames()
   {
      return testCases.keySet();
   }

   public TestInfo findTest(TestId id)
   {
      switch(id.getLength())
      {
         case 0:
            return this;
         case 1:
            return getTest(id.getName(0));
         default:
            return null;
      }
   }
}
