/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.unit.info;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;

/**
 * Describe something we can test.
 *
 * @author <a href="mailto:julien@jboss.org">Julien Viet</a>
 * @version $Revision: 1.1 $
 */
public interface TestInfo extends Serializable
{

   /**
    * Returns the name.
    *
    * @return the name.
    */
   String getName();

   /**
    * Returns the description.
    *
    * @return the description
    */
   String getDescription();

   /**
    * Returns a map of parameters required to execute the test related to this description. For a test case
    * it returns a map of parameters to execute this test case. For a test suite it returns a map
    * formed by the union of the maps returned by the children of the test suite.
    *
    * @return the parameters
    */
   Map<String,? extends ParameterInfo> getParameters();

   /**
    * Returns the set of keywords.
    *
    * @return the set of keywords
    */
   Set<String> getKeywords();
}
