/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.unit.info.impl;

import org.jboss.unit.info.ParameterInfo;

import java.util.List;
import java.util.ArrayList;
import java.util.Collections;

/**
 * @author <a href="mailto:julien@jboss.org">Julien Viet</a>
 * @version $Revision: 1.1 $
 */
public class SimpleParameterInfo implements ParameterInfo
{

   /** . */
   private final String name;

   /** . */
   private String description;

   /** . */
   private List<String> defaultValues;

   public SimpleParameterInfo(String name)
   {
      if (name == null)
      {
         throw new IllegalArgumentException("No null value accepted");
      }
      this.name = name;
      this.description = null;
      this.defaultValues = new ArrayList<String>();
   }

   public SimpleParameterInfo(ParameterInfo that)
   {
      if (that == null)
      {
         throw new IllegalArgumentException("No null value accepted");
      }
      this.name = that.getName();
      this.description = that.getDescription();
      this.defaultValues = new ArrayList<String>(that.getDefaultValues());
   }

   public String getName()
   {
      return name;
   }

   public String getDescription()
   {
      return description;
   }

   public void setDescription(String description)
   {
      this.description = description;
   }

   public List<String> getDefaultValues()
   {
      return Collections.unmodifiableList(defaultValues);
   }

   public void setDefaultValues(List<String> defaultValues)
   {
      if (defaultValues == null)
      {
         throw new IllegalArgumentException();
      }
      this.defaultValues = new ArrayList<String>(defaultValues);
   }
}
