/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.unit.info.impl;

import org.jboss.unit.info.TestCaseInfo;
import org.jboss.unit.info.ParameterInfo;

import java.util.Map;
import java.util.HashMap;

/**
 * @author <a href="mailto:julien@jboss.org">Julien Viet</a>
 * @version $Revision: 1.1 $
 */
public class SimpleTestCaseInfo extends SimpleTestInfo implements TestCaseInfo
{
   public SimpleTestCaseInfo(String name)
   {
      super(name);
   }

   public SimpleTestCaseInfo(TestCaseInfo that)
   {
      super(that);
   }

   public String toString()
   {
      return getName();
   }

   public void setParameters(Map<String, ? extends ParameterInfo> parameters)
   {
      if (parameters == null)
      {
         throw new IllegalArgumentException();
      }

      //
      Map<String, SimpleParameterInfo> tmp = new HashMap<String, SimpleParameterInfo>();
      for (Map.Entry<String, ? extends ParameterInfo> entry : parameters.entrySet())
      {
         tmp.put(entry.getKey(), new SimpleParameterInfo(entry.getValue()));
      }
      this.parameters = tmp;
   }

   public void addParameter(ParameterInfo parameter)
   {
      if (parameter == null)
      {
         throw new IllegalArgumentException();
      }
      SimpleParameterInfo tmp = new SimpleParameterInfo(parameter);
      parameters.put(tmp.getName(), tmp);
   }

   public void removeParameter(String name)
   {
      if (name == null)
      {
         throw new IllegalArgumentException();
      }
      parameters.remove(name);
   }
}
