/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.unit.info.impl;

import org.jboss.unit.info.TestSuiteInfo;
import org.jboss.unit.info.TestInfo;
import org.jboss.unit.TestId;

import java.util.Map;
import java.util.HashMap;
import java.util.Set;
import java.util.Collections;
import java.util.Iterator;

/**
 * @author <a href="mailto:julien@jboss.org">Julien Viet</a>
 * @version $Revision: 1.1 $
 */
public class SimpleTestSuiteInfo extends SimpleTestInfo implements TestSuiteInfo
{

   private Map<String, SimpleTestInfo> tests;

   public SimpleTestSuiteInfo(String name)
   {
      super(name);

      //
      this.tests = new HashMap<String, SimpleTestInfo>();
   }

   public SimpleTestSuiteInfo(TestSuiteInfo that)
   {
      super(that);

      //
      this.tests = new HashMap<String, SimpleTestInfo>();

      //
      for (String testName : that.getNames())
      {
         TestInfo test = that.getTest(testName);
         addTest(test);
      }
   }

   public TestInfo getTest(String name)
   {
      return tests.get(name);
   }

   public Set<String> getNames()
   {
      return Collections.unmodifiableSet(tests.keySet());
   }

   public TestInfo findTest(TestId id)
   {
      if (id == null)
      {
         throw new IllegalArgumentException("No null id accepted");
      }

      //
      if (id.getLength() == 0)
      {
         return this;
      }

      //
      TestInfo child = tests.get(id.getName(0));

      //
      if (child == null)
      {
         return null;
      }

      //
      if (child instanceof TestSuiteInfo)
      {
         return ((TestSuiteInfo)child).findTest(id.range(1));
      }
      else if (id.getLength() == 1)
      {
         return child;
      }
      else
      {
         return null;
      }
   }

   public void addTest(TestInfo test)
   {
      if (test == null)
      {
         throw new IllegalArgumentException();
      }
      tests.put(test.getName(), create(test));

      // Update parameter map
      updateParameters();
   }

   public void removeTest(String testName)
   {
      if (testName == null)
      {
         throw new IllegalArgumentException();
      }
      tests.remove(testName);

      // Update parameter map
      updateParameters();
   }

   /**
    * Rebuild the suite parameters from the children parameters.
    */
   private void updateParameters()
   {
      Map<String, SimpleParameterInfo> parameters = new HashMap<String, SimpleParameterInfo>();
      for (SimpleTestInfo child : tests.values())
      {
         parameters.putAll(child.parameters);
      }
      this.parameters = parameters;
   }

   public String toString()
   {
      StringBuilder builder = new StringBuilder(getName());
      builder.append('[');
      for (Iterator i = tests.values().iterator();i.hasNext();)
      {
         TestInfo test = (TestInfo)i.next();
         builder.append(test);
         if (i.hasNext())
         {
            builder.append(',');
         }
      }
      builder.append(']');
      return builder.toString();
   }

}
