/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.unit.report.impl.junit;

import org.jboss.unit.runner.TestRunnerEvent;
import org.jboss.unit.runner.TestRunnerEventListener;
import org.jboss.unit.runner.event.EndRunnerEvent;
import org.jboss.unit.runner.event.EndTestCaseEvent;
import org.jboss.unit.runner.event.EndTestSuiteEvent;
import org.jboss.unit.runner.event.RunnerFailureEvent;
import org.jboss.unit.runner.event.StartRunnerEvent;
import org.jboss.unit.runner.event.StartTestCaseEvent;
import org.jboss.unit.runner.event.StartTestSuiteEvent;
import org.jboss.unit.tooling.SystemOutputManager;
import org.jboss.unit.tooling.SystemOutputView;

import java.io.StringWriter;
import java.io.IOException;

/**
 *
 * @author <a href="mailto:julien@jboss.org">Julien Viet</a>
 * @author <a href="mailto:emuckenh@redhat.com">Emanuel Muckenhuber</a>
 * @version $Revision: 1.1 $
 */
public class JUnitReporter implements TestRunnerEventListener
{
   /** The JUnit test report */
   private JUnitTestReport report;

   /** To dir */
   private String toDir;

   private SystemOutputView view;

   public JUnitReporter(String reportToDir)
   {
      toDir = reportToDir;
      // redirecting system out and err

      this.report = new JUnitTestReport();
   }

   public JUnitReporter(String reportToDir,
         String testSuiteName)
   {
      this(reportToDir);

      this.report.setTestSuiteName(testSuiteName);


   }
   
   public void onEvent(TestRunnerEvent event)
   {
      if (event instanceof StartRunnerEvent)
      {
         report.startJUnitTestSuite((StartRunnerEvent) event);
         view = SystemOutputManager.getInstance().createView(false);
      }
      else if (event instanceof EndRunnerEvent)
      {
         // append system out and system err
         try
         {
            StringWriter out = new StringWriter();
            StringWriter err = new StringWriter();
            view.writeTo(out, err);
            report.appendSystemError(err.toString());
            report.appendSystemOutput(out.toString());
         }
         catch (IOException e)
         {
            e.printStackTrace();
         }

         // Testsuite End
         report.endTestSuite((EndRunnerEvent) event);
         
         // Export xml
         report.exportXML(toDir);
      }
      else if (event instanceof RunnerFailureEvent)
      {
         report.runnerFailed((RunnerFailureEvent) event);
      }
      else if (event instanceof StartTestSuiteEvent)
      {
         report.addTestedSuiteName(((StartTestSuiteEvent) event).getTestInfo().getName());
      }
      else if (event instanceof EndTestSuiteEvent)
      {
         report.removeLastTestedSuite();
      }
      else if (event instanceof StartTestCaseEvent)
      {
         report.startTest((StartTestCaseEvent) event);
      }
      else if (event instanceof EndTestCaseEvent)
      {
         report.endTest((EndTestCaseEvent) event);
      }
   }
}
