/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.unit.report.impl.junit;

/**
 * <p> Interface groups XML constants.
 * Interface that groups all constants used throughout the <tt>XML</tt>
 * documents that are generated by the <tt>XMLJUnitResultFormatter</tt>
 * As of now the DTD is:
 * <code><pre>
 *
 * </pre></code>
 */
public class XMLConstants {

    /** the testsuites element for the aggregate document */
    public static final String TESTSUITES = "testsuites";

    /** the testsuite element */
    public static final String TESTSUITE = "testsuite";

    /** the testcase element */
    public static final String TESTCASE = "testcase";

    /** the error element */
    public static final String ERROR = "error";

    /** the failure element */
    public static final String FAILURE = "failure";

    /** the system-err element */
    public static final String SYSTEM_ERR = "system-err";

    /** the system-out element */
    public static final String SYSTEM_OUT = "system-out";

    /** package attribute for the aggregate document */
    public static final String ATTR_PACKAGE = "package";

    /** name attribute for property, testcase and testsuite elements */
    public static final String ATTR_NAME = "name";

    /** time attribute for testcase and testsuite elements */
    public static final String ATTR_TIME = "time";

    /** errors attribute for testsuite elements */
    public static final String ATTR_ERRORS = "errors";

    /** failures attribute for testsuite elements */
    public static final String ATTR_FAILURES = "failures";

    /** tests attribute for testsuite elements */
    public static final String ATTR_TESTS = "tests";

    /** type attribute for failure and error elements */
    public static final String ATTR_TYPE = "type";

    /** message attribute for failure elements */
    public static final String ATTR_MESSAGE = "message";

    /** the properties element */
    public static final String PROPERTIES = "properties";

    /** the property element */
    public static final String PROPERTY = "property";

    /** value attribute for property elements */
    public static final String ATTR_VALUE = "value";

    /** classname attribute for testcase elements */
    public static final String ATTR_CLASSNAME = "classname";

    /** id attribute */
    public static final String ATTR_ID = "id";
    
    /** timestamp of test cases */
    public static final String TIMESTAMP = "timestamp";

    /** name of host running the tests */
    public static final String HOSTNAME = "hostname";

}

/*
 * Copyright  2001,2004-2005 The Apache Software Foundation
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
