/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.unit.runner;

import java.util.Map;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.HashSet;
import java.util.ArrayList;

/**
 * @author <a href="mailto:julien@jboss.org">Julien Viet</a>
 * @version $Revision: 1.1 $
 */
public class ParametrizationSet implements Cloneable
{

   /** . */
   private Map<String,String[]> map;

   public ParametrizationSet(Map<String, String[]> map)
   {
      this.map = map;
   }

   public ParametrizationSet()
   {
      this.map = new HashMap<String, String[]>();
   }

   public void combine(ParametrizationSet other) throws IllegalArgumentException
   {
      if (other == null)
      {
         throw new IllegalArgumentException();
      }
      for (Map.Entry<String,String[]> entry : other.map.entrySet())
      {
         String key = entry.getKey();

         //
         map.put(key, entry.getValue().clone());
      }
   }

   public ParametrizationSet clone()
   {
      try
      {
         return (ParametrizationSet)super.clone();
      }
      catch (CloneNotSupportedException e)
      {
         throw new Error(e);
      }
   }

   /**
    * Enumerate the list of parametrization generated by this set.
    *
    * @param expectedParameters a filter to retain a sub set of the parameters
    * @return a list of parametrizations
    */
   public List<Map<String,String>> enumerate(Set<String> expectedParameters)
   {
      // Clone so we can modify it safely
      expectedParameters = expectedParameters != null ? new HashSet<String>(expectedParameters) : null;

      //
      List<Map<String,String>> enumeration = new ArrayList<Map<String, String>>();

      //
      enumeration.add(new HashMap<String, String>());

      //
      for (Map.Entry<String, String[]> entry : map.entrySet())
      {
         String parameterName = entry.getKey();

         //
         if (expectedParameters == null || expectedParameters.remove(parameterName))
         {

            List<Map<String,String>> tmp = new ArrayList<Map<String, String>>();

            for (String occurrence : entry.getValue())
            {
               for (Map<String,String> blah : enumeration)
               {
                  Map<String,String> copy = new HashMap<String,String>(blah);
                  copy.put(parameterName, occurrence);
                  tmp.add(copy);
               }
            }

            enumeration = tmp;
         }
      }

      //
      return enumeration;
   }

}
