/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.unit.runner.impl;

import org.jboss.unit.runner.TestRunnerEventListener;
import org.jboss.unit.runner.TestRunnerEvent;
import org.jboss.unit.runner.event.StartRunnerEvent;
import org.jboss.unit.runner.event.EndRunnerEvent;

/**
 * <p>The goal of this listener class is to route events to a target listener and operate on the events
 * with the following manner:</p>
 * <p>
 * <ul>
 * <li>Absorb any event of type <code>StartRunnerEvent</code> or <code>EndRunnerEvent</code></li>
 * <li>Event of type <code>StartTestEvent</code> or <code>EndTestEvent</code> have their test id transformed
 *     by adding the <code>testName</code> field as prefix of the id</li>
 * </ul>
 * </p>
 * <p>The use case of this class is a test runner which delegates to another test runner and wants to absorb the
 * life cycle events emitted by the runner and apply a transformation of the test id of the test life cycle events
 * emitted by the runner.
 * </p>
 *
 * @author <a href="mailto:julien@jboss.org">Julien Viet</a>
 * @version $Revision: 1.1 $
 */
public class DelegateRunnerEventFilter implements TestRunnerEventListener
{

   /** . */
   private TestRunnerEventListener listener;

   public DelegateRunnerEventFilter(TestRunnerEventListener listener)
   {
      this.listener = listener;
   }

   public void onEvent(TestRunnerEvent event)
   {
      if (event instanceof StartRunnerEvent || event instanceof EndRunnerEvent)
      {
         return;
      }
      listener.onEvent(event);
   }
}
