/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.unit.runner.impl;

import org.jboss.unit.runner.TestRunnerContext;
import org.jboss.unit.runner.TestFilter;
import org.jboss.unit.runner.TestRunnerEventListener;
import org.jboss.unit.runner.ParametrizationSet;

import java.util.Map;
import java.util.HashMap;

/**
 * @author <a href="mailto:julien@jboss.org">Julien Viet</a>
 * @version $Revision: 1.1 $
 */
public class TestRunnerContextSupport implements TestRunnerContext
{

   /** . */
   private Map<String,String> properties;

   /** . */
   private ParametrizationSet parameters;

   /** . */
   private TestFilter filter;

   /** . */
   private TestRunnerEventListener eventListener;


   public TestRunnerContextSupport(TestRunnerEventListener eventListener)
   {
      this(new HashMap<String, String>(), new ParametrizationSet(), NullFilter.getInstance(), eventListener);
   }

   public TestRunnerContextSupport(ParametrizationSet parametrizations)
   {
      this(new HashMap<String, String>(), parametrizations, NullFilter.getInstance(), new TestRunnerEventBroadcaster());
   }

   public TestRunnerContextSupport(Map<String, String> properties)
   {
      this(properties, new ParametrizationSet(), NullFilter.getInstance(), new TestRunnerEventBroadcaster());
   }

   public TestRunnerContextSupport(ParametrizationSet parametrizations, TestRunnerEventListener eventListener)
   {
      this(new HashMap<String, String>(), parametrizations, NullFilter.getInstance(), eventListener);
   }

   public TestRunnerContextSupport()
   {
      this(new HashMap<String, String>(), new ParametrizationSet(), NullFilter.getInstance(), new TestRunnerEventBroadcaster());
   }

   public TestRunnerContextSupport(Map<String, String> properties, ParametrizationSet parametrizations, TestFilter filter, TestRunnerEventListener eventListener)
   {
      this.properties = properties;
      this.parameters = parametrizations;
      this.filter = filter;
      this.eventListener = eventListener;
   }

   public Map<String, String> getProperties()
   {
      return properties;
   }

   public ParametrizationSet getParametrizations()
   {
      return parameters;
   }

   public TestFilter getFilter()
   {
      return filter;
   }

   public TestRunnerEventListener getEventListener()
   {
      return eventListener;
   }
}
