/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.unit.runner.impl.composite;

import org.jboss.unit.runner.AbstractTestRunner;
import org.jboss.unit.runner.TestRunner;
import org.jboss.unit.runner.TestRunnerContext;
import org.jboss.unit.runner.impl.TestRunnerContextSupport;
import org.jboss.unit.runner.impl.TestRunnerEventBroadcaster;
import org.jboss.unit.runner.impl.TestRunnerLifeCycleFilter;

import java.util.Collection;

/**
 * A composite test runner that executes a suite of test runners. If a runner throws an unchecked throwable during
 * the execution of its <code>run</code> method then composite runner will not make an attempt to catch it
 * and thus the execution will stop.
 *
 * @author <a href="mailto:julien@jboss.org">Julien Viet</a>
 * @version $Revision: 1.1 $
 */
public class CompositeTestRunner extends AbstractTestRunner
{

   /** . */
   private final Collection<TestRunner> runners;

   public CompositeTestRunner(Collection<TestRunner> runners)
   {
      this.runners = runners;
   }

   protected void internalRun(TestRunnerContext context)
   {
      // Setup intermediate event filtering
      TestRunnerEventBroadcaster tmp = new TestRunnerEventBroadcaster();
      tmp.addListener(new TestRunnerLifeCycleFilter(context.getEventListener()));
      TestRunnerContextSupport nestedContext = new TestRunnerContextSupport(context.getProperties(), context.getParametrizations(), context.getFilter(), tmp);

      for (TestRunner runner : runners)
      {
         runner.run(nestedContext);
      }
   }
}
