/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.unit.runner.impl.generic;

import org.jboss.unit.runner.AbstractTestRunner;
import org.jboss.unit.runner.ParametrizationSet;
import org.jboss.unit.runner.TestRunnerContext;
import org.jboss.unit.runner.event.RunnerFailureEvent;
import org.jboss.unit.runner.impl.driver.TestDriverRunner;
import org.jboss.unit.runner.impl.TestRunnerContextSupport;
import org.jboss.unit.runner.impl.DelegateRunnerEventFilter;
import org.jboss.unit.runner.model.generic.GenericTestSuiteDef;
import org.jboss.unit.runner.model.generic.TestDef;
import org.jboss.unit.driver.TestDriver;
import org.jboss.unit.TestId;
import org.jboss.unit.Failure;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.HashMap;

/**
 * @author <a href="mailto:julien@jboss.org">Julien Viet</a>
 * @version $Revision: 1.1 $
 */
public class GenericTestRunner extends AbstractTestRunner
{

   /** . */
   private final GenericTestSuiteDef def;

   public GenericTestRunner(GenericTestSuiteDef def)
   {
      this.def = def;
   }

   protected void internalRun(final TestRunnerContext context)
   {
      String className = def.getClassName();

      //
      DelegateRunnerEventFilter filter = new DelegateRunnerEventFilter(context.getEventListener());

      //
      try
      {
         Class<TestDriver> clazz = (Class<TestDriver>)Thread.currentThread().getContextClassLoader().loadClass(className);
         TestDriver driver = clazz.newInstance();

         //
         Collection<TestDef> testDefs = def.getTests();

         // If nothing is provided we execute the whole suite
         if (testDefs.isEmpty())
         {
            testDefs = Collections.singleton(new TestDef(new TestId()));
         }

         // Compute properties
         Map<String, String> properties = new HashMap<String, String>(def.getProperties());
         properties.putAll(context.getProperties());

         for (TestDef testDef : testDefs)
         {
            // Create parametrization
            ParametrizationSet parametrizations = def.getParameters().getParametrization().clone();
            parametrizations.combine(testDef.getParameters().getParametrization());
            parametrizations.combine(context.getParametrizations());

            //
            TestRunnerContextSupport genericContext = new TestRunnerContextSupport(properties, parametrizations, context.getFilter(), filter);

            //
            TestDriverRunner runner = new TestDriverRunner(driver, testDef.getRefId());

            //
            runner.run(genericContext);
         }
      }
      catch (Exception e)
      {
         context.getEventListener().onEvent(new RunnerFailureEvent(Failure.createFailure("Cannot execute test class " + className,e)));
      }
   }
}
