/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.unit.runner.impl.pojo;

import org.jboss.unit.runner.AbstractTestRunner;
import org.jboss.unit.runner.ParametrizationSet;
import org.jboss.unit.runner.TestRunnerContext;
import org.jboss.unit.runner.impl.driver.TestDriverRunner;
import org.jboss.unit.runner.impl.TestRunnerContextSupport;
import org.jboss.unit.runner.impl.DelegateRunnerEventFilter;
import org.jboss.unit.runner.event.RunnerFailureEvent;
import org.jboss.unit.runner.model.pojo.POJOTestSuiteDef;
import org.jboss.unit.runner.model.pojo.TestClassDef;
import org.jboss.unit.runner.model.pojo.TestCaseDef;
import org.jboss.unit.TestId;
import org.jboss.unit.Failure;
import org.jboss.unit.info.TestSuiteInfo;
import org.jboss.unit.driver.impl.pojo.POJOTestSuiteDriver;
import org.jboss.unit.driver.TestDriver;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;

/**
 * @author <a href="mailto:julien@jboss.org">Julien Viet</a>
 * @version $Revision: 1.1 $
 */
public class POJOTestRunner extends AbstractTestRunner
{

   /** . */
   private final POJOTestSuiteDef def;

   public POJOTestRunner(POJOTestSuiteDef suiteDef)
   {
      this.def = suiteDef;
   }

   protected void internalRun(TestRunnerContext context)
   {
      for (TestClassDef testClass : def.getTestClasses())
      {
         String className = testClass.getName();

         //
         DelegateRunnerEventFilter filter = new DelegateRunnerEventFilter(context.getEventListener());

         //
         try
         {
            Class clazz = Thread.currentThread().getContextClassLoader().loadClass(className);

            //
            TestDriver driver = new POJOTestSuiteDriver(clazz);
            TestSuiteInfo testSuiteInfo = (TestSuiteInfo)driver.getInfo();

            //
            List<String> testCaseNames = new ArrayList<String>();
            for (TestCaseDef testCase : testClass.getTestCases())
            {
               testCaseNames.add(testCase.getName());
            }
            if (testCaseNames.size() == 0)
            {
               testCaseNames.addAll(testSuiteInfo.getNames());
            }

            // Create parametrization
            ParametrizationSet parametrizations = def.getParameters().getParametrization().clone();
            parametrizations.combine(testClass.getParameters().getParametrization());
            parametrizations.combine(context.getParametrizations());

            // Compute properties
            Map<String, String> properties = new HashMap<String, String>(testClass.getProperties());
            properties.putAll(context.getProperties());

            //
            TestRunnerContextSupport pojoContext = new TestRunnerContextSupport(properties, parametrizations, context.getFilter(), filter);

            //
            TestDriverRunner runner = new TestDriverRunner(driver);

            //
            for (String testCaseName : testCaseNames)
            {
               TestId testCaseId = new TestId(testCaseName);
               runner.setTestId(testCaseId);
               runner.run(pojoContext);
            }
         }
         catch (Exception e)
         {
            context.getEventListener().onEvent(new RunnerFailureEvent(Failure.createFailure("Cannot execute test class " + className,e)));
         }
      }
   }
}
