/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.unit.runner.model;

import org.jboss.unit.util.CollectionTools;

import java.util.Iterator;
import java.util.ArrayList;
import java.util.List;

/**
 * @author <a href="mailto:julien@jboss.org">Julien Viet</a>
 * @version $Revision: 1.1 $
 */
public class ParameterValueDef implements Iterable<String>
{

   /** . */
   private List<String> list;

   public ParameterValueDef(String... ts)
   {
      this(CollectionTools.list(ts));
   }

   public ParameterValueDef(Iterable<String> iterable)
   {
      if (iterable == null)
      {
         throw new IllegalArgumentException("No null iterable should be provided");
      }
      ArrayList<String> list = new ArrayList<String>();
      for (String s : iterable)
      {
         list.add(s);
      }
      this.list = list;
   }

   public List<String> list()
   {
      return list;
   }

   public Iterator<String> iterator()
   {
      return list.iterator();
   }
}
