/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.unit.runner.model;

import org.jboss.unit.runner.ParametrizationSet;

import java.util.Map;
import java.util.HashMap;
import java.util.Set;

/**
 * A set of parameters.
 *
 * @author <a href="mailto:julien@jboss.org">Julien Viet</a>
 * @version $Revision: 1.1 $
 */
public class ParametersDef
{

   /** . */
   private final Map<String, ParameterValueDef> map = new HashMap<String, ParameterValueDef>();

   public void setParameter(String name, String value)
   {
      setParameter(name, new ParameterValueDef(value));
   }

   public void setParameter(String name, ParameterValueDef value)
   {
      if (name == null)
      {
         throw new IllegalArgumentException("No null parameter name");
      }
      if (value == null)
      {
         map.remove(name);
      }
      else
      {
         map.put(name, value);
      }
   }

   public void removeParameter(String name)
   {
      setParameter(name, (ParameterValueDef)null);
   }

   public ParameterValueDef getParameter(String name)
   {
      if (name == null)
      {
         throw new IllegalArgumentException("No null parameter name");
      }

      //
      return map.get(name);
   }

   public Set<String> getNames()
   {
      return map.keySet();
   }

   public ParametrizationSet getParametrization()
   {
      Map<String,String[]> tmp = new HashMap<String,String[]>();
      for (Map.Entry<String,ParameterValueDef> entry : map.entrySet())
      {
         tmp.put(entry.getKey(), entry.getValue().list().toArray(new String[0]));
      }
      return new ParametrizationSet(tmp);
   }
}
