/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.unit.runner.model.generic;

import org.jboss.unit.runner.model.TestSuiteDef;
import org.jboss.unit.runner.model.BuilderException;
import org.jboss.unit.runner.TestRunner;
import org.jboss.unit.runner.impl.generic.GenericTestRunner;

import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;

/**
 * @author <a href="mailto:julien@jboss.org">Julien Viet</a>
 * @version $Revision: 1.1 $
 */
public class GenericTestSuiteDef extends TestSuiteDef
{

   /** The tests. */
   private final List<TestDef> tests = new ArrayList<TestDef>();

   /** . */
   private final String className;

   /** . */
   private Map<String, String> properties = new HashMap<String, String>();

   public GenericTestSuiteDef(String className)
   {
      this.className = className;
   }

   public String getClassName()
   {
      return className;
   }

   public TestRunner createRunner() throws BuilderException
   {
      return new GenericTestRunner(this);
   }

   public void addTest(TestDef test)
   {
      if (test == null)
      {
         throw new IllegalArgumentException();
      }
      tests.add(test);
   }

   public List<TestDef> getTests()
   {
      return tests;
   }

   public Map<String, String> getProperties()
   {
      return properties;
   }

   public void setProperties(Map<String, String> properties)
   {
      this.properties = properties;
   }

   public void setProperty(String name, String value)
   {
      if (name == null)
      {
         throw new IllegalArgumentException();
      }
      if (value == null)
      {
         properties.remove(name);
      }
      else
      {
         properties.put(name, value);
      }
   }
}
