/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.unit.runner.model.pojo;

import org.jboss.unit.runner.model.ParametersDef;

import java.util.Map;
import java.util.HashMap;
import java.util.Collection;

/**
 * @author <a href="mailto:julien@jboss.org">Julien Viet</a>
 * @version $Revision: 1.1 $
 */
public class TestClassDef
{

   /** . */
   private String name;

   /** . */
   private Map<String,TestCaseDef> testCases = new HashMap<String, TestCaseDef>();

   /** . */
   private ParametersDef parameters = new ParametersDef();

   /** . */
   private Map<String, String> properties = new HashMap<String, String>();

   public TestClassDef(String name)
   {
      if (name == null)
      {
         throw new IllegalArgumentException("No null name accepted");
      }

      //
      this.name = name;
   }

   public String getName()
   {
      return name;
   }

   public Collection<TestCaseDef> getTestCases()
   {
      return testCases.values();
   }

   public void addTestCase(TestCaseDef testCaseDef)
   {
      if (testCaseDef == null)
      {
         throw new IllegalArgumentException("No null test case accepted");
      }
      testCases.put(testCaseDef.getName(), testCaseDef);
   }

   public TestCaseDef getTestCase(String name)
   {
      if (name == null)
      {
         throw new IllegalArgumentException("No null test case name accepted");
      }
      return testCases.get(name);
   }

   public ParametersDef getParameters()
   {
      return parameters;
   }

   public void setParameters(ParametersDef parameters)
   {
      this.parameters = parameters;
   }

   public Map<String, String> getProperties()
   {
      return properties;
   }

   public void setProperties(Map<String, String> properties)
   {
      this.properties = properties;
   }

   public void setProperty(String name, String value)
   {
      if (name == null)
      {
         throw new IllegalArgumentException();
      }
      if (value == null)
      {
         properties.remove(name);
      }
      else
      {
         properties.put(name, value);
      }
   }
}
