/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.unit.spi.pojo;

import java.util.List;
import java.util.ArrayList;
import java.lang.reflect.Method;

/**
 * @author <a href="mailto:julien@jboss.org">Julien Viet</a>
 * @version $Revision: 1.1 $
 */
class MethodKey implements Comparable
{

   /** . */
   private String name;

   /** . */
   private List<String> types;

   MethodKey(Method method)
   {
      List<String> types = new ArrayList<String>();
      for (Class type : method.getParameterTypes())
      {
         types.add(type.getName());
      }

      this.name = method.getName();
      this.types = types;
   }

   public int hashCode()
   {
      return name.hashCode() + types.hashCode();
   }

   public boolean equals(Object object)
   {
      if (object == this)
      {
         return true;
      }
      if (object instanceof MethodKey)
      {
         MethodKey that = (MethodKey)object;
         return that.name.equals(this.name) && that.types.equals(this.types);
      }
      return false;
   }

   public int compareTo(Object o)
   {
      MethodKey that = (MethodKey)o;

      //
      int sign = name.compareTo(that.name);
      if (sign != 0)
      {
         return sign;
      }

      //
      for (int index = 0;index < this.types.size() && index < that.types.size();index++)
      {
         String thisName = this.types.get(index);
         String thatName = that.types.get(index);

         //
         int order = thisName.compareTo(thatName);
         if (order != 0)
         {
            return order;
         }
      }

      //
      return that.types.size() - this.types.size();
   }
}
