/*
* JBoss, a division of Red Hat
* Copyright 2006, Red Hat Middleware, LLC, and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/

package org.jboss.unit.tooling;

import org.jboss.unit.runner.TestResult;
import org.jboss.unit.runner.TestRunnerEvent;
import org.jboss.unit.runner.TestRunnerEventListener;
import org.jboss.unit.runner.results.TestFailure;
import org.jboss.unit.runner.event.EndTestCaseEvent;
import org.jboss.unit.runner.event.RunnerFailureEvent;

/**
 * Event Listener that manages runner failures.
 *
 * @author <a href="mailto:boleslaw dot dawidowicz at redhat anotherdot com">Boleslaw Dawidowicz</a>
 * @version : 0.1 $
 */
public class FailureManagerListener implements TestRunnerEventListener
{
   private boolean runnerFailure = false;

   private boolean testCaseFailure = false;

   public void onEvent(TestRunnerEvent event)
   {
      if (event instanceof RunnerFailureEvent)
      {
         // Return with code -1
         //System.exit(-1);
         runnerFailure = true;
      }
      if (event instanceof EndTestCaseEvent)
      {
         EndTestCaseEvent endEvent = (EndTestCaseEvent)event;
         TestResult result = endEvent.getTestResult();

         if (result instanceof TestFailure)
         {
            // Return with code -1
            //System.exit(-1);
            testCaseFailure = true;
         }
      }
   }

   public void reset()
   {
      runnerFailure = false;
      testCaseFailure = false;
   }

   public boolean isRunnerFailure()
   {
      return runnerFailure;
   }

   public boolean isTestCaseFailure()
   {
      return testCaseFailure;
   }
}
