/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.unit.tooling;

import java.io.OutputStream;
import java.io.IOException;

/**
 * @author <a href="mailto:julien@jboss.org">Julien Viet</a>
 * @version $Revision: 1.1 $
 */
class ForkedOutputStream extends OutputStream
{

   /** . */
   private final OutputStream out1;

   /** . */
   private final OutputStream out2;

   public ForkedOutputStream(OutputStream out1, OutputStream out2)
   {
      this.out1 = out1;
      this.out2 = out2;
   }

   public void write(int i) throws IOException
   {
      safeWrite(out1, i);
      safeWrite(out2, i);
   }

   public void flush() throws IOException
   {
      safeFlush(out1);
      safeFlush(out2);
   }

   private void safeWrite(OutputStream out, int i)
   {
      try
      {
         out.write(i);
      }
      catch (IOException ignore)
      {
      }
   }

   private void safeFlush(OutputStream out)
   {
      try
      {
         out.flush();
      }
      catch (IOException ignore)
      {
      }
   }
}
