/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.unit.tooling;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

/**
 * @author <a href="mailto:julien@jboss.org">Julien Viet</a>
 * @version $Revision: 1.1 $
 */
public class SystemOutputManager
{

   /** . */
   private static SystemOutputManager instance;

   /** . */
   private PrintStream originalOut;

   /** . */
   private PrintStream originalErr;

   /** . */
   private ByteArrayOutputStreamExt baosOut;

   /** . */
   private ByteArrayOutputStreamExt baosErr;

   public SystemOutputManager()
   {
   }

   public static SystemOutputManager getInstance()
   {
      return instance;
   }

   public SystemOutputView createView(boolean fullHistory)
   {
      return new SystemOutputView(baosOut, baosErr, fullHistory);
   }

   public void start()
   {
      synchronized (SystemOutputManager.class)
      {
         if (instance != null)
         {
            throw new IllegalStateException();
         }

         //
         baosOut = new ByteArrayOutputStreamExt();
         baosErr = new ByteArrayOutputStreamExt();
         originalOut = System.out;
         originalErr = System.err;
         ForkedOutputStream fOut = new ForkedOutputStream(originalOut, baosOut);
         ForkedOutputStream fErr = new ForkedOutputStream(originalErr, baosErr);

         //
         System.setOut(new PrintStream(fOut, true));
         System.setErr(new PrintStream(fErr, true));
         instance = this;
      }
   }

   public void stop()
   {
      synchronized (SystemOutputManager.class)
      {
         if (instance != null)
         {
            System.out.flush();
            System.err.flush();
            instance = null;
            System.setOut(originalOut);
            System.setErr(originalErr);
         }
      }
   }
}
