/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.unit.tooling;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

/**
 * @author <a href="mailto:julien@jboss.org">Julien Viet</a>
 * @version $Revision: 1.1 $
 */
public class SystemOutputView
{

   /** . */
   private ByteArrayOutputStreamExt out;

   /** . */
   private ByteArrayOutputStreamExt err;

   /** . */
   private int outCount;

   /** . */
   private int errCount;

   public SystemOutputView(ByteArrayOutputStreamExt out, ByteArrayOutputStreamExt err, boolean fullHistory)
   {
      this.out = out;
      this.err = err;
      this.outCount = fullHistory ? 0 : out.size();
      this.errCount = fullHistory ? 0 : err.size();
   }

   public void writeTo(OutputStream toOut, OutputStream toErr) throws IOException
   {
      outCount = out.writeTo(toOut, outCount);
      errCount = err.writeTo(toErr, errCount);
   }

   public void writeTo(Writer toOut, Writer toErr) throws IOException
   {
      outCount = out.writeTo(toOut, outCount);
      errCount = err.writeTo(toErr, errCount);
   }

   public void reset()
   {
      outCount = 0;
      errCount = 0;
   }
}
