/*
* JBoss, a division of Red Hat
* Copyright 2006, Red Hat Middleware, LLC, and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/

package org.jboss.unit.tooling.filter;

import org.jboss.unit.runner.TestFilter;
import org.jboss.unit.TestId;
import org.jboss.unit.info.TestInfo;

import java.util.Map;
import java.util.List;
import java.util.LinkedList;

/**
 * @author <a href="mailto:boleslaw dot dawidowicz at redhat anotherdot com">Boleslaw Dawidowicz</a>
 * @version $Revision: 0.1 $
 */
public class MainTestFilter implements TestFilter
{

   private List<TestFilter> includeFilters = new LinkedList();

   private List<TestFilter> excludeFilters = new LinkedList();


   public MainTestFilter()
   {
   }

   public MainTestFilter(List<TestFilter> matchFilters, List<TestFilter> excludeFilters)
   {
      if (matchFilters == null)
      {
         throw new IllegalArgumentException("includeFilters cannot be null");
      }
      if (excludeFilters == null)
      {
         throw new IllegalArgumentException("excludeFilters cannot be null");
      }


      this.includeFilters = matchFilters;
      this.excludeFilters = excludeFilters;
   }

   public boolean include(TestId testId, TestInfo testInfo)
   {

      // First check if test isn't excluded

      // Make logic OR on all filters

      for (TestFilter ef : excludeFilters)
      {
         if (!ef.include(testId, testInfo))
         {
            return false;
         }
      }

      // make logic OR on all match filters

      for (TestFilter mf : includeFilters)
      {
         if (mf.include(testId, testInfo))
         {
            return true;
         }

      }


      return false;
   }

   public boolean include(TestId testId, Map<String, String> parametrization, TestInfo testInfo)
   {
      
      // At the moment no parametrization match

      return include (testId, testInfo);
   }

   public void addIncludeFilter(TestFilter filter)
   {
      if (filter == null)
      {
         throw new IllegalArgumentException("filter cannot be null");
      }
      includeFilters.add(filter);
   }

   public void addExcludeFilter(TestFilter filter)
   {
      if (filter == null)
      {
         throw new IllegalArgumentException("filter cannot be null");
      }
      excludeFilters.add(filter);
   }


}
