/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.unit.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.List;
import java.util.Iterator;

/**
 * @author <a href="mailto:julien@jboss.org">Julien Viet</a>
 * @version $Revision: 1.1 $
 */
public class CollectionTools
{

   public static <U> Iterable<U> iterable(final Iterator<U> iterator)
   {
      return new Iterable<U>()
      {
         public Iterator<U> iterator()
         {
            return iterator;
         }
      };
   }

   public static <U> Set<U> set()
   {
      return new HashSet<U>();
   }

   /**
    * @throws IllegalArgumentException if the argument is null
    */
   public static <U> Set<U> set(U... us) throws IllegalArgumentException
   {
      return collection(new HashSet<U>(), us);
   }

   /**
    * @throws IllegalArgumentException if the argument is null
    */
   public static <U> Set<U> set(Iterable<U> us) throws IllegalArgumentException
   {
      return collection(new HashSet<U>(), us);
   }

   public static <U> List<U> list()
   {
      return new ArrayList<U>();
   }

   /**
    * @throws IllegalArgumentException if the argument is null
    */
   public static <U> List<U> list(U... us) throws IllegalArgumentException
   {
      return collection(new ArrayList<U>(), us);
   }

   /**
    * @throws IllegalArgumentException if the argument is null
    */
   public static <U> List<U> list(Iterable<U> us) throws IllegalArgumentException
   {
      return collection(new ArrayList<U>(), us);
   }

   private static <U,T extends Collection<U>> T collection(T collection, U... us)
   {
      if (us == null)
      {
         throw new IllegalArgumentException("No null array accepted");
      }
      for (U u : us)
      {
         collection.add(u);
      }
      return collection;
   }

   private static <U,T extends Collection<U>> T collection(T collection, Iterable<U> us)
   {
      if (us == null)
      {
         throw new IllegalArgumentException("No null array accepted");
      }
      for (U u : us)
      {
         collection.add(u);
      }
      return collection;
   }

}
