/******************************************************************************
 * JBoss, a division of Red Hat                                               *
 * Copyright 2006, Red Hat Middleware, LLC, and individual                    *
 * contributors as indicated by the @authors tag. See the                     *
 * copyright.txt in the distribution for a full listing of                    *
 * individual contributors.                                                   *
 *                                                                            *
 * This is free software; you can redistribute it and/or modify it            *
 * under the terms of the GNU Lesser General Public License as                *
 * published by the Free Software Foundation; either version 2.1 of           *
 * the License, or (at your option) any later version.                        *
 *                                                                            *
 * This software is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU           *
 * Lesser General Public License for more details.                            *
 *                                                                            *
 * You should have received a copy of the GNU Lesser General Public           *
 * License along with this software; if not, write to the Free                *
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA         *
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.                   *
 ******************************************************************************/
package org.jboss.unit.util;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

import java.util.Collection;
import java.util.ArrayList;

/**
 * @author <a href="mailto:julien@jboss.org">Julien Viet</a>
 * @version $Revision: 1.1 $
 */
public class XMLTools
{

   public static Collection<Element> children(Element element, String... names)
   {
      if (element == null)
      {
         throw new IllegalArgumentException();
      }
      if (names == null)
      {
         throw new IllegalArgumentException();
      }

      //
      NodeList childNodes = element.getChildNodes();

      //
      Collection<Element> childElements = new ArrayList<Element>(childNodes.getLength());
      for (int i = 0; i < childNodes.getLength(); i++)
      {
         Node childNode = childNodes.item(i);
         if (childNode.getNodeType() == Node.ELEMENT_NODE)
         {
            String childName = childNode.getNodeName();
            if (names.length == 0)
            {
               childElements.add((Element)childNode);
            }
            else
            {
               for (String name : names)
               {
                  if (childName.equals(name))
                  {
                     childElements.add((Element)childNode);
                  }
               }
            }
         }
      }

      //
      return childElements;
   }

   public static Element child(Element element, String name)
   {
      if (element == null)
      {
         throw new IllegalArgumentException();
      }
      if (name == null)
      {
         throw new IllegalArgumentException();
      }

      //
      NodeList childNodes = element.getChildNodes();

      //
      Element childElement = null;
      for (int i = 0; i < childNodes.getLength(); i++)
      {
         Node childNode = childNodes.item(i);
         if (childNode.getNodeType() == Node.ELEMENT_NODE && name.equals(childNode.getNodeName()))
         {
            if (childElement != null)
            {
               throw new IllegalArgumentException();
            }
            else
            {
               childElement = (Element)childNode;
            }
         }
      }

      //
      return childElement;
   }

   public static String text(Element element)
   {
      if (element == null)
      {
         throw new IllegalArgumentException();
      }

      //
      NodeList childNodes = element.getChildNodes();

      //
      StringBuffer tmp = new StringBuffer();
      for (int i = 0; i < childNodes.getLength(); i++)
      {
         Node childNode = childNodes.item(i);
         switch (childNode.getNodeType())
         {
            case Node.TEXT_NODE:
               Text text = (Text)childNode;
               tmp.append(text.getData());
               break;
            case Node.ELEMENT_NODE:
               throw new IllegalArgumentException();
         }
      }

      //
      return tmp.toString();
   }
}
