/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet.deployment;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Set;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileVisitor;
import org.jboss.virtual.VisitorAttributes;
import org.jboss.weld.environment.servlet.deployment.URLScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VFSURLScanner
extends URLScanner {
    private static final Logger log = LoggerFactory.getLogger(VFSURLScanner.class);

    public VFSURLScanner(ClassLoader classLoader) {
        super(classLoader);
    }

    @Override
    protected void handleArchiveByFile(File file, final Set<String> classes, final Set<URL> urls) throws IOException {
        try {
            log.trace("archive: " + file);
            final VirtualFile archive = VFS.getRoot((URI)file.toURI());
            archive.visit(new VirtualFileVisitor(){

                public VisitorAttributes getAttributes() {
                    return VisitorAttributes.RECURSE_LEAVES_ONLY;
                }

                public void visit(VirtualFile vf) {
                    try {
                        String name = VFSURLScanner.getRelativePath(archive, vf);
                        URL url = vf.toURL();
                        VFSURLScanner.this.handle(name, url, classes, urls);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Error handling file " + file, e);
        }
    }

    static String getRelativePath(VirtualFile parent, VirtualFile child) {
        if (child == null) {
            throw new IllegalArgumentException("Null child");
        }
        String childPath = child.getPathName();
        if (parent != null) {
            String parentPath = parent.getPathName();
            if (parentPath.length() == childPath.length()) {
                return "";
            }
            if (parentPath.length() < childPath.length()) {
                if (!parentPath.endsWith("/")) {
                    parentPath = parentPath + "/";
                }
                if (childPath.startsWith(parentPath)) {
                    return childPath.substring(parentPath.length());
                }
            }
        }
        if (childPath.endsWith("/")) {
            childPath = childPath.substring(0, childPath.length() - 1);
        }
        return childPath;
    }
}

