/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.deployment.discovery;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Set;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.environment.deployment.discovery.DiscoveryStrategy;
import org.jboss.weld.environment.deployment.discovery.ReflectionDiscoveryStrategy;
import org.jboss.weld.environment.logging.CommonLogger;
import org.jboss.weld.environment.util.Reflections;
import org.jboss.weld.resources.spi.ResourceLoader;

public final class DiscoveryStrategyFactory {
    private static final String JANDEX_DISCOVERY_STRATEGY_CLASS_NAME = "org.jboss.weld.environment.deployment.discovery.jandex.JandexDiscoveryStrategy";
    private static final String JANDEX_INDEX_CLASS_NAME = "org.jboss.jandex.Index";

    private DiscoveryStrategyFactory() {
    }

    public static DiscoveryStrategy create(ResourceLoader resourceLoader, Bootstrap bootstrap, Set<Class<? extends Annotation>> initialBeanDefiningAnnotations) {
        if (Reflections.isClassLoadable(resourceLoader, JANDEX_INDEX_CLASS_NAME)) {
            CommonLogger.LOG.usingJandex();
            try {
                return (DiscoveryStrategy)Reflections.cast(Reflections.classForName(resourceLoader, JANDEX_DISCOVERY_STRATEGY_CLASS_NAME).getConstructor(ResourceLoader.class, Bootstrap.class, Set.class).newInstance(resourceLoader, bootstrap, initialBeanDefiningAnnotations));
            }
            catch (Exception e) {
                throw CommonLogger.LOG.unableToInstantiate(JANDEX_DISCOVERY_STRATEGY_CLASS_NAME, Arrays.toString(new Object[]{resourceLoader, bootstrap, initialBeanDefiningAnnotations}), e);
            }
        }
        return new ReflectionDiscoveryStrategy(resourceLoader, bootstrap, initialBeanDefiningAnnotations);
    }
}

