/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedType;
import org.jboss.weld.exceptions.DefinitionException;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.logging.BeanLogger;
import org.jboss.weld.logging.BeanManagerLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.util.InterceptorBindingSet;

public class Interceptors {
    private Interceptors() {
    }

    public static Set<Annotation> filterInterceptorBindings(BeanManagerImpl beanManager, Collection<Annotation> annotations) {
        InterceptorBindingSet interceptorBindings = new InterceptorBindingSet(beanManager);
        for (Annotation annotation : annotations) {
            if (!beanManager.isInterceptorBinding(annotation.annotationType())) continue;
            interceptorBindings.add(annotation);
        }
        return interceptorBindings;
    }

    public static Set<Annotation> flattenInterceptorBindings(BeanManagerImpl beanManager, Collection<Annotation> annotations, boolean addTopLevelInterceptorBindings, boolean addInheritedInterceptorBindings) {
        InterceptorBindingSet flattenInterceptorBindings = new InterceptorBindingSet(beanManager);
        if (addTopLevelInterceptorBindings) {
            for (Annotation annotation : annotations) {
                boolean added = flattenInterceptorBindings.add(annotation);
                if (added) continue;
                throw BeanManagerLogger.LOG.duplicateInterceptorBinding(annotations);
            }
        }
        if (addInheritedInterceptorBindings) {
            for (Annotation annotation : annotations) {
                Interceptors.addInheritedInterceptorBindings(annotation.annotationType(), beanManager.getServices().get(MetaAnnotationStore.class), flattenInterceptorBindings);
            }
        }
        return flattenInterceptorBindings;
    }

    private static void addInheritedInterceptorBindings(Class<? extends Annotation> bindingType, MetaAnnotationStore store, Set<Annotation> inheritedBindings) {
        Set<Annotation> metaBindings = store.getInterceptorBindingModel(bindingType).getInheritedInterceptionBindingTypes();
        inheritedBindings.addAll(metaBindings);
        for (Annotation metaBinding : metaBindings) {
            Interceptors.addInheritedInterceptorBindings(metaBinding.annotationType(), store, inheritedBindings);
        }
    }

    public static Map<Class<? extends Annotation>, Annotation> mergeBeanInterceptorBindings(BeanManagerImpl beanManager, AnnotatedType<?> clazz, Collection<Class<? extends Annotation>> stereotypes) {
        Set<Annotation> classBindingAnnotations = Interceptors.flattenInterceptorBindings(beanManager, Interceptors.filterInterceptorBindings(beanManager, clazz.getAnnotations()), true, false);
        HashSet<Annotation> inheritedBindingAnnotations = new HashSet<Annotation>();
        inheritedBindingAnnotations.addAll(Interceptors.flattenInterceptorBindings(beanManager, Interceptors.filterInterceptorBindings(beanManager, clazz.getAnnotations()), false, true));
        for (Class<? extends Annotation> annotation : stereotypes) {
            inheritedBindingAnnotations.addAll(Interceptors.flattenInterceptorBindings(beanManager, Interceptors.filterInterceptorBindings(beanManager, beanManager.getStereotypeDefinition(annotation)), true, true));
        }
        try {
            return Interceptors.mergeBeanInterceptorBindings(beanManager, clazz, classBindingAnnotations, inheritedBindingAnnotations);
        }
        catch (DeploymentException e) {
            throw new DefinitionException(BeanLogger.LOG.conflictingInterceptorBindings(clazz.getJavaClass()));
        }
    }

    public static Map<Class<? extends Annotation>, Annotation> mergeBeanInterceptorBindings(BeanManagerImpl beanManager, AnnotatedType<?> clazz, Collection<Annotation> classBindingAnnotations, Collection<Annotation> inheritedBindingAnnotations) {
        HashMap<Class<? extends Annotation>, Annotation> mergedBeanBindings = new HashMap<Class<? extends Annotation>, Annotation>();
        HashMap<Class<? extends Annotation>, Annotation> acceptedInheritedBindingTypes = new HashMap<Class<? extends Annotation>, Annotation>();
        for (Annotation bindingAnnotation : classBindingAnnotations) {
            if (mergedBeanBindings.containsKey(bindingAnnotation.annotationType())) {
                throw new DeploymentException(BeanLogger.LOG.conflictingInterceptorBindings(clazz.getJavaClass()));
            }
            mergedBeanBindings.put(bindingAnnotation.annotationType(), bindingAnnotation);
        }
        for (Annotation bindingAnnotation : inheritedBindingAnnotations) {
            Class<? extends Annotation> bindingAnnotationType = bindingAnnotation.annotationType();
            Annotation previousValue = (Annotation)mergedBeanBindings.get(bindingAnnotationType);
            if (previousValue == null) {
                mergedBeanBindings.put(bindingAnnotationType, bindingAnnotation);
                acceptedInheritedBindingTypes.put(bindingAnnotationType, bindingAnnotation);
                continue;
            }
            if (!acceptedInheritedBindingTypes.containsKey(bindingAnnotationType) || beanManager.getServices().get(MetaAnnotationStore.class).getInterceptorBindingModel(bindingAnnotationType).isEqual(previousValue, bindingAnnotation, true)) continue;
            throw new DeploymentException(BeanLogger.LOG.conflictingInterceptorBindings(clazz.getJavaClass()));
        }
        return mergedBeanBindings;
    }
}

