/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.channels;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import org.jboss.xnio.channels.StreamSinkChannel;

public class BlockingWritableByteChannel
implements GatheringByteChannel {
    private final StreamSinkChannel delegate;

    public BlockingWritableByteChannel(StreamSinkChannel delegate) {
        this.delegate = delegate;
    }

    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        long res;
        StreamSinkChannel delegate = this.delegate;
        while ((res = delegate.write(srcs, offset, length)) == 0L) {
            delegate.awaitWritable();
        }
        return res;
    }

    public long write(ByteBuffer[] srcs) throws IOException {
        long res;
        StreamSinkChannel delegate = this.delegate;
        while ((res = delegate.write(srcs)) == 0L) {
            delegate.awaitWritable();
        }
        return res;
    }

    public int write(ByteBuffer src) throws IOException {
        int res;
        StreamSinkChannel delegate = this.delegate;
        while ((res = delegate.write(src)) == 0) {
            delegate.awaitWritable();
        }
        return res;
    }

    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    public void close() throws IOException {
        this.delegate.close();
    }
}

