/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.nio;

import java.io.Closeable;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import org.jboss.xnio.ConfigurableFactory;
import org.jboss.xnio.IoHandlerFactory;
import org.jboss.xnio.UdpServer;
import org.jboss.xnio.channels.ChannelOption;
import org.jboss.xnio.channels.CommonOptions;
import org.jboss.xnio.channels.UdpChannel;
import org.jboss.xnio.nio.AbstractConfigurable;
import org.jboss.xnio.nio.BioUdpServer;
import org.jboss.xnio.nio.BioUdpServerConfig;
import org.jboss.xnio.nio.NioXnio;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BioUdpServerFactory
extends AbstractConfigurable
implements ConfigurableFactory<UdpServer> {
    private static final Set<ChannelOption<?>> options;
    private final NioXnio xnio;
    private final Executor executor;
    private final IoHandlerFactory<? super UdpChannel> factory;
    private final SocketAddress[] initialAddresses;
    private final Object lock = new Object();
    private boolean created;

    BioUdpServerFactory(NioXnio xnio, Executor executor, IoHandlerFactory<? super UdpChannel> factory, SocketAddress[] initialAddresses) {
        super(options);
        this.xnio = xnio;
        this.executor = executor;
        this.factory = factory;
        this.initialAddresses = initialAddresses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UdpServer create() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.created) {
                throw new IllegalStateException("Already created");
            }
            BioUdpServerConfig config = new BioUdpServerConfig();
            config.setExecutor(this.executor);
            config.setHandlerFactory(this.factory);
            config.setInitialAddresses(this.initialAddresses);
            config.setReuseAddresses((Boolean)this.getOption(CommonOptions.REUSE_ADDRESSES));
            config.setReceiveBuffer((Integer)this.getOption(CommonOptions.RECEIVE_BUFFER));
            config.setSendBuffer((Integer)this.getOption(CommonOptions.SEND_BUFFER));
            config.setTrafficClass((Integer)this.getOption(CommonOptions.IP_TRAFFIC_CLASS));
            config.setBroadcast((Boolean)this.getOption(CommonOptions.BROADCAST));
            BioUdpServer udpServer = BioUdpServer.create(config, this.xnio);
            this.xnio.addManaged((Closeable)((Object)udpServer));
            this.created = true;
            return udpServer;
        }
    }

    static {
        HashSet<ChannelOption> optionSet = new HashSet<ChannelOption>();
        optionSet.add(CommonOptions.REUSE_ADDRESSES);
        optionSet.add(CommonOptions.RECEIVE_BUFFER);
        optionSet.add(CommonOptions.SEND_BUFFER);
        optionSet.add(CommonOptions.IP_TRAFFIC_CLASS);
        optionSet.add(CommonOptions.BROADCAST);
        options = Collections.unmodifiableSet(optionSet);
    }
}

