/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.nio;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.Executor;
import org.jboss.xnio.AbstractFutureConnection;
import org.jboss.xnio.FailedFutureConnection;
import org.jboss.xnio.FinishedFutureConnection;
import org.jboss.xnio.FutureConnection;
import org.jboss.xnio.IoHandler;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.TcpAcceptor;
import org.jboss.xnio.TcpChannelDestination;
import org.jboss.xnio.channels.BoundChannel;
import org.jboss.xnio.channels.TcpChannel;
import org.jboss.xnio.log.Logger;
import org.jboss.xnio.nio.HandlerUtils;
import org.jboss.xnio.nio.NioHandle;
import org.jboss.xnio.nio.NioTcpAcceptorConfig;
import org.jboss.xnio.nio.NioTcpChannel;
import org.jboss.xnio.nio.NioXnio;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NioTcpAcceptor
implements TcpAcceptor {
    private static final Logger log = Logger.getLogger((String)"org.jboss.xnio.nio.tcp.acceptor");
    private final NioXnio nioXnio;
    private final Executor executor;
    private final Boolean keepAlive;
    private final Boolean oobInline;
    private final Integer receiveBufferSize;
    private final Boolean reuseAddress;
    private final Boolean tcpNoDelay;
    private final boolean manageConnections;

    private NioTcpAcceptor(NioTcpAcceptorConfig config) {
        this.nioXnio = config.getXnio();
        this.executor = config.getExecutor();
        if (this.nioXnio == null) {
            throw new NullPointerException("nioXnio is null");
        }
        if (this.executor == null) {
            throw new NullPointerException("executor is null");
        }
        this.keepAlive = config.getKeepAlive();
        this.oobInline = config.getOobInline();
        this.receiveBufferSize = config.getReceiveBuffer();
        this.reuseAddress = config.getReuseAddresses();
        this.tcpNoDelay = config.getNoDelay();
        this.manageConnections = config.isManageConnections();
    }

    static NioTcpAcceptor create(NioTcpAcceptorConfig config) {
        return new NioTcpAcceptor(config);
    }

    public FutureConnection<InetSocketAddress, TcpChannel> acceptTo(InetSocketAddress dest, IoHandler<? super TcpChannel> handler) {
        try {
            ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
            serverSocketChannel.configureBlocking(false);
            ServerSocket serverSocket = serverSocketChannel.socket();
            if (this.receiveBufferSize != null) {
                serverSocket.setReceiveBufferSize(this.receiveBufferSize);
            }
            if (this.reuseAddress != null) {
                serverSocket.setReuseAddress(this.reuseAddress);
            }
            serverSocket.bind(dest, 1);
            SocketChannel socketChannel = serverSocketChannel.accept();
            if (socketChannel != null) {
                return new FinishedFutureConnection((BoundChannel)new NioTcpChannel(this.nioXnio, socketChannel, handler, this.executor, this.manageConnections));
            }
            Handler nioHandler = new Handler(serverSocketChannel, handler);
            NioHandle handle = this.nioXnio.addConnectHandler(serverSocketChannel, nioHandler, true);
            nioHandler.handle = handle;
            handle.resume(16);
            return nioHandler.future;
        }
        catch (IOException e) {
            return new FailedFutureConnection(e, (Object)dest);
        }
    }

    public TcpChannelDestination createChannelDestination(final InetSocketAddress dest) {
        return new TcpChannelDestination(){

            public FutureConnection<InetSocketAddress, TcpChannel> accept(IoHandler<? super TcpChannel> handler) {
                return NioTcpAcceptor.this.acceptTo(dest, handler);
            }
        };
    }

    public String toString() {
        return String.format("TCP acceptor (NIO) <%s>", Integer.toString(this.hashCode(), 16));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Handler
    implements Runnable {
        private final FutureImpl future;
        private final ServerSocketChannel serverSocketChannel;
        private final IoHandler<? super TcpChannel> handler;
        private volatile NioHandle handle;

        public Handler(ServerSocketChannel serverSocketChannel, IoHandler<? super TcpChannel> handler) {
            this.serverSocketChannel = serverSocketChannel;
            this.handler = handler;
            this.future = new FutureImpl(NioTcpAcceptor.this.executor, (InetSocketAddress)serverSocketChannel.socket().getLocalSocketAddress());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                boolean ok = false;
                SocketChannel socketChannel = this.serverSocketChannel.accept();
                if (socketChannel == null) {
                    this.handle.resume(16);
                    return;
                }
                try {
                    NioTcpChannel channel;
                    IoUtils.safeClose((Closeable)this.serverSocketChannel);
                    socketChannel.configureBlocking(false);
                    Socket socket = socketChannel.socket();
                    if (NioTcpAcceptor.this.keepAlive != null) {
                        socket.setKeepAlive(NioTcpAcceptor.this.keepAlive);
                    }
                    if (NioTcpAcceptor.this.oobInline != null) {
                        socket.setOOBInline(NioTcpAcceptor.this.oobInline);
                    }
                    if (NioTcpAcceptor.this.tcpNoDelay != null) {
                        socket.setTcpNoDelay(NioTcpAcceptor.this.tcpNoDelay);
                    }
                    if (ok = HandlerUtils.handleOpened(this.handler, channel = new NioTcpChannel(NioTcpAcceptor.this.nioXnio, socketChannel, this.handler, NioTcpAcceptor.this.executor, NioTcpAcceptor.this.manageConnections))) {
                        NioTcpAcceptor.this.nioXnio.addManaged(channel);
                        log.trace("TCP server accepted connection");
                    }
                    this.future.setResult(channel);
                }
                finally {
                    if (!ok) {
                        log.trace("TCP server failed to accept connection");
                        IoUtils.safeClose((Closeable)this.serverSocketChannel);
                        IoUtils.safeClose((Closeable)socketChannel);
                    }
                }
            }
            catch (ClosedChannelException e) {
                IoUtils.safeClose((Closeable)this.serverSocketChannel);
                log.trace("Channel closed: %s", (Object)e.getMessage());
                this.future.setException(e);
            }
            catch (IOException e) {
                IoUtils.safeClose((Closeable)this.serverSocketChannel);
                log.trace((Throwable)e, "I/O error on TCP server", new Object[0]);
                this.future.setException(e);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class FutureImpl
        extends AbstractFutureConnection<InetSocketAddress, TcpChannel> {
            private final Executor executor;
            private final InetSocketAddress localAddress;

            public FutureImpl(Executor executor, InetSocketAddress address) {
                this.executor = executor;
                this.localAddress = address;
            }

            protected boolean setException(IOException exception) {
                return super.setException(exception);
            }

            protected boolean setResult(TcpChannel result) {
                return super.setResult((Object)result);
            }

            protected boolean finishCancel() {
                return super.finishCancel();
            }

            protected Executor getNotifierExecutor() {
                return this.executor;
            }

            public InetSocketAddress getLocalAddress() {
                return this.localAddress;
            }

            public FutureConnection<InetSocketAddress, TcpChannel> cancel() {
                IoUtils.safeClose((Closeable)Handler.this.serverSocketChannel);
                this.finishCancel();
                return this;
            }
        }
    }
}

