/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.activity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.nuxeo.ecm.activity.Activity;
import org.nuxeo.ecm.activity.ActivityBuilder;
import org.nuxeo.ecm.activity.ActivityHelper;
import org.nuxeo.ecm.activity.ActivityStreamService;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.SystemPrincipal;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.event.impl.ShallowDocumentModel;
import org.nuxeo.runtime.api.Framework;

public class ActivityStreamListener
implements PostCommitEventListener {
    public void handleEvent(EventBundle events) {
        if (this.isEventBundleHandled(events)) {
            List<Event> filteredEvents = this.filterDuplicateEvents(events);
            for (Event event : filteredEvents) {
                this.handleEvent(event);
            }
        }
    }

    protected List<Event> filterDuplicateEvents(EventBundle events) {
        List<Event> filteredEvents = new ArrayList<Event>();
        for (Event event : events) {
            filteredEvents = this.removeEventIfExist(filteredEvents, event);
            filteredEvents.add(event);
        }
        return filteredEvents;
    }

    protected List<Event> removeEventIfExist(List<Event> events, Event event) {
        EventContext eventContext = event.getContext();
        if (eventContext instanceof DocumentEventContext) {
            DocumentModel doc = ((DocumentEventContext)eventContext).getSourceDocument();
            Iterator<Event> it = events.iterator();
            while (it.hasNext()) {
                Event filteredEvent = it.next();
                EventContext filteredEventContext = filteredEvent.getContext();
                if (!(filteredEventContext instanceof DocumentEventContext)) continue;
                DocumentModel filteredEventDoc = ((DocumentEventContext)filteredEventContext).getSourceDocument();
                if (!event.getName().equals(filteredEvent.getName()) || !doc.getRef().equals(filteredEventDoc.getRef())) continue;
                it.remove();
                break;
            }
        }
        return events;
    }

    protected void handleEvent(Event event) {
        EventContext eventContext = event.getContext();
        if (eventContext instanceof DocumentEventContext && this.isEventHandled(event)) {
            DocumentEventContext docEventContext = (DocumentEventContext)eventContext;
            DocumentModel doc = docEventContext.getSourceDocument();
            if (this.isSkippedDocument(doc)) {
                return;
            }
            if (docEventContext.getPrincipal() instanceof SystemPrincipal) {
                return;
            }
            ActivityStreamService activityStreamService = (ActivityStreamService)Framework.getService(ActivityStreamService.class);
            Activity activity = this.toActivity(docEventContext, event);
            activityStreamService.addActivity(activity);
            CoreSession session = docEventContext.getCoreSession();
            for (DocumentRef ref : this.getParentSuperSpaceRefs(session, doc)) {
                String context = ActivityHelper.createDocumentActivityObject(session.getRepositoryName(), ref.toString());
                activity = this.toActivity(docEventContext, event, context);
                activityStreamService.addActivity(activity);
            }
        }
    }

    protected boolean isSkippedDocument(DocumentModel doc) {
        return doc instanceof ShallowDocumentModel || doc.hasFacet("HiddenInNavigation") || doc.hasFacet("SystemDocument") || doc.isProxy() || doc.isVersion();
    }

    protected boolean isEventHandled(Event event) {
        for (String eventName : this.getHandledEventsName()) {
            if (!eventName.equals(event.getName())) continue;
            return true;
        }
        return false;
    }

    protected boolean isEventBundleHandled(EventBundle events) {
        for (String eventName : this.getHandledEventsName()) {
            if (!events.containsEventName(eventName)) continue;
            return true;
        }
        return false;
    }

    protected List<String> getHandledEventsName() {
        return Arrays.asList("documentCreated", "documentModified", "documentRemoved");
    }

    protected Activity toActivity(DocumentEventContext docEventContext, Event event) {
        return this.toActivity(docEventContext, event, null);
    }

    protected Activity toActivity(DocumentEventContext docEventContext, Event event, String context) {
        NuxeoPrincipal principal = docEventContext.getPrincipal();
        DocumentModel doc = docEventContext.getSourceDocument();
        return new ActivityBuilder().actor(ActivityHelper.createUserActivityObject(principal)).displayActor(ActivityHelper.generateDisplayName(principal)).verb(event.getName()).object(ActivityHelper.createDocumentActivityObject(doc)).displayObject(ActivityHelper.getDocumentTitle(doc)).target(ActivityHelper.createDocumentActivityObject(doc.getRepositoryName(), doc.getParentRef().toString())).displayTarget(this.getDocumentTitle(docEventContext.getCoreSession(), doc.getParentRef())).context(context).build();
    }

    protected String getDocumentTitle(CoreSession session, DocumentRef docRef) {
        try {
            DocumentModel doc = session.getDocument(docRef);
            return ActivityHelper.getDocumentTitle(doc);
        }
        catch (DocumentNotFoundException e) {
            return docRef.toString();
        }
    }

    protected List<DocumentRef> getParentSuperSpaceRefs(CoreSession session, final DocumentModel doc) {
        final ArrayList<DocumentRef> parents = new ArrayList<DocumentRef>();
        new UnrestrictedSessionRunner(session){

            public void run() {
                List parentDocuments = this.session.getParentDocuments(doc.getRef());
                for (DocumentModel parent : parentDocuments) {
                    if (!parent.hasFacet("SuperSpace")) continue;
                    parents.add(parent.getRef());
                }
            }
        }.runUnrestricted();
        return parents;
    }
}

