package org.nuxeo.connect.update;

import java.util.EnumSet;

/**
 * Enum for types of packages
 *
 * @author tiry
 *
 */
public enum PackageType {

    STUDIO("studio"), HOT_FIX("hotfix"), ADDON("addon");

    private final String value;

    PackageType(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    @Override
    public String toString() {
        return getValue();
    }

    public static PackageType getByValue(String value) {
        PackageType returnValue = null;
        for (final PackageType element : EnumSet.allOf(PackageType.class)) {
            if (element.toString().equals(value)) {
                returnValue = element;
            }
        }
        return returnValue;
    }

}
