/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.binary.metadata.internals;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.binary.metadata.api.BinaryMetadataException;
import org.nuxeo.binary.metadata.api.BinaryMetadataProcessor;
import org.nuxeo.binary.metadata.api.BinaryMetadataService;
import org.nuxeo.binary.metadata.internals.BinaryMetadataComponent;
import org.nuxeo.binary.metadata.internals.MetadataMappingDescriptor;
import org.nuxeo.binary.metadata.internals.MetadataRuleDescriptor;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.BlobProvider;
import org.nuxeo.ecm.platform.actions.ActionContext;
import org.nuxeo.ecm.platform.actions.ELActionContext;
import org.nuxeo.ecm.platform.actions.ejb.ActionManager;
import org.nuxeo.runtime.api.Framework;

public class BinaryMetadataServiceImpl
implements BinaryMetadataService {
    private static final Log log = LogFactory.getLog(BinaryMetadataServiceImpl.class);
    protected BinaryMetadataComponent binaryMetadataComponent;

    protected BinaryMetadataServiceImpl(BinaryMetadataComponent binaryMetadataComponent) {
        this.binaryMetadataComponent = binaryMetadataComponent;
    }

    @Override
    public Map<String, Object> readMetadata(String processorName, Blob blob, List<String> metadataNames, boolean ignorePrefix) {
        try {
            BinaryMetadataProcessor processor = this.getProcessor(processorName);
            return processor.readMetadata(blob, metadataNames, ignorePrefix);
        }
        catch (NoSuchMethodException e) {
            throw new BinaryMetadataException(e);
        }
    }

    @Override
    public Map<String, Object> readMetadata(Blob blob, List<String> metadataNames, boolean ignorePrefix) {
        try {
            BinaryMetadataProcessor processor = this.getProcessor("exifTool");
            return processor.readMetadata(blob, metadataNames, ignorePrefix);
        }
        catch (NoSuchMethodException e) {
            throw new BinaryMetadataException(e);
        }
    }

    @Override
    public Map<String, Object> readMetadata(Blob blob, boolean ignorePrefix) {
        try {
            BinaryMetadataProcessor processor = this.getProcessor("exifTool");
            return processor.readMetadata(blob, ignorePrefix);
        }
        catch (NoSuchMethodException e) {
            throw new BinaryMetadataException(e);
        }
    }

    @Override
    public Map<String, Object> readMetadata(String processorName, Blob blob, boolean ignorePrefix) {
        try {
            BinaryMetadataProcessor processor = this.getProcessor(processorName);
            return processor.readMetadata(blob, ignorePrefix);
        }
        catch (NoSuchMethodException e) {
            throw new BinaryMetadataException(e);
        }
    }

    @Override
    public Blob writeMetadata(String processorName, Blob blob, Map<String, Object> metadata, boolean ignorePrefix) {
        try {
            BinaryMetadataProcessor processor = this.getProcessor(processorName);
            return processor.writeMetadata(blob, metadata, ignorePrefix);
        }
        catch (NoSuchMethodException e) {
            throw new BinaryMetadataException(e);
        }
    }

    @Override
    public Blob writeMetadata(Blob blob, Map<String, Object> metadata, boolean ignorePrefix) {
        try {
            BinaryMetadataProcessor processor = this.getProcessor("exifTool");
            return processor.writeMetadata(blob, metadata, ignorePrefix);
        }
        catch (NoSuchMethodException e) {
            throw new BinaryMetadataException(e);
        }
    }

    @Override
    public Blob writeMetadata(String processorName, Blob blob, String mappingDescriptorId, DocumentModel doc) {
        try {
            HashMap<String, Object> metadataMapping = new HashMap<String, Object>();
            MetadataMappingDescriptor mappingDescriptor = this.binaryMetadataComponent.mappingRegistry.getMappingDescriptorMap().get(mappingDescriptorId);
            for (MetadataMappingDescriptor.MetadataDescriptor metadataDescriptor : mappingDescriptor.getMetadataDescriptors()) {
                metadataMapping.put(metadataDescriptor.getName(), doc.getPropertyValue(metadataDescriptor.getXpath()));
            }
            BinaryMetadataProcessor processor = this.getProcessor(processorName);
            return processor.writeMetadata(blob, metadataMapping, mappingDescriptor.getIgnorePrefix());
        }
        catch (NoSuchMethodException e) {
            throw new BinaryMetadataException(e);
        }
    }

    @Override
    public Blob writeMetadata(Blob blob, String mappingDescriptorId, DocumentModel doc) {
        return this.writeMetadata("exifTool", blob, mappingDescriptorId, doc);
    }

    @Override
    public void writeMetadata(DocumentModel doc) {
        ActionContext actionContext = this.createActionContext(doc);
        Set<MetadataRuleDescriptor> ruleDescriptors = this.checkFilter(actionContext);
        ArrayList<String> mappingDescriptorIds = new ArrayList<String>();
        for (MetadataRuleDescriptor ruleDescriptor : ruleDescriptors) {
            mappingDescriptorIds.addAll(ruleDescriptor.getMetadataMappingIdDescriptors());
        }
        if (mappingDescriptorIds.isEmpty()) {
            return;
        }
        for (String mappingDescriptorId : mappingDescriptorIds) {
            if (!this.binaryMetadataComponent.mappingRegistry.getMappingDescriptorMap().containsKey(mappingDescriptorId)) {
                log.warn((Object)("Missing binary metadata descriptor with id '" + mappingDescriptorId + "'. Or check your rule contribution with proper metadataMapping-id."));
                continue;
            }
            this.writeMetadata(doc, mappingDescriptorId);
        }
    }

    @Override
    public void writeMetadata(DocumentModel doc, String mappingDescriptorId) {
        HashMap<String, String> metadataMapping = new HashMap<String, String>();
        ArrayList<String> blobMetadata = new ArrayList<String>();
        MetadataMappingDescriptor mappingDescriptor = this.binaryMetadataComponent.mappingRegistry.getMappingDescriptorMap().get(mappingDescriptorId);
        boolean ignorePrefix = mappingDescriptor.getIgnorePrefix();
        Blob blob = (Blob)doc.getProperty(mappingDescriptor.getBlobXPath()).getValue(Blob.class);
        if (blob != null && mappingDescriptor.getMetadataDescriptors() != null && !mappingDescriptor.getMetadataDescriptors().isEmpty()) {
            for (MetadataMappingDescriptor.MetadataDescriptor metadataDescriptor : mappingDescriptor.getMetadataDescriptors()) {
                metadataMapping.put(metadataDescriptor.getName(), metadataDescriptor.getXpath());
                blobMetadata.add(metadataDescriptor.getName());
            }
            String processorId = mappingDescriptor.getProcessor();
            Map<String, Object> blobMetadataOutput = processorId != null ? this.readMetadata(processorId, blob, blobMetadata, ignorePrefix) : this.readMetadata(blob, blobMetadata, ignorePrefix);
            for (String metadata : blobMetadataOutput.keySet()) {
                List<Object> metadataValue = blobMetadataOutput.get(metadata);
                boolean metadataIsArray = metadataValue instanceof Object[] || metadataValue instanceof List;
                String property = (String)metadataMapping.get(metadata);
                if (!(metadataValue instanceof Date || metadataValue instanceof Collection || metadataIsArray)) {
                    metadataValue = metadataValue.toString();
                }
                if (metadataValue instanceof String) {
                    metadataValue = ((String)((Object)metadataValue)).replace("\u0000", "");
                }
                try {
                    if (doc.getProperty(property).isList()) {
                        if (!metadataIsArray) {
                            metadataValue = Arrays.asList(metadataValue);
                        }
                    } else if (metadataIsArray) {
                        metadataValue = metadataValue instanceof Object[] ? Arrays.asList((Object[])metadataValue) : metadataValue.toString();
                    }
                    doc.setPropertyValue(property, (Serializable)((Object)metadataValue));
                }
                catch (PropertyException e) {
                    log.warn((Object)String.format("Failed to set property '%s' to value %s from metadata '%s' in '%s' in document '%s' ('%s')", property, metadataValue, metadata, mappingDescriptor.getBlobXPath(), doc.getId(), doc.getPath()));
                }
            }
        }
    }

    @Override
    public void handleSyncUpdate(DocumentModel doc) {
        List<MetadataMappingDescriptor> syncMappingDescriptors = this.getSyncMapping(doc);
        if (syncMappingDescriptors != null) {
            this.handleUpdate(syncMappingDescriptors, doc);
        }
    }

    @Override
    public void handleUpdate(List<MetadataMappingDescriptor> mappingDescriptors, DocumentModel doc) {
        for (MetadataMappingDescriptor mappingDescriptor : mappingDescriptors) {
            Property fileProp = doc.getProperty(mappingDescriptor.getBlobXPath());
            Blob blob = (Blob)fileProp.getValue(Blob.class);
            if (blob == null) continue;
            boolean isDirtyMapping = this.isDirtyMapping(mappingDescriptor, doc);
            if (isDirtyMapping) {
                BlobManager blobManager = (BlobManager)Framework.getService(BlobManager.class);
                BlobProvider blobProvider = blobManager.getBlobProvider(blob);
                if (!(blobProvider == null || blobProvider.supportsUserUpdate() && blobProvider.getBinaryManager() != null)) {
                    return;
                }
                Blob newBlob = this.writeMetadata(mappingDescriptor.getProcessor(), (Blob)fileProp.getValue(Blob.class), mappingDescriptor.getId(), doc);
                fileProp.setValue((Object)newBlob);
                continue;
            }
            if (!fileProp.isDirty()) continue;
            this.writeMetadata(doc);
        }
    }

    protected Set<MetadataRuleDescriptor> checkFilter(ActionContext actionContext) {
        ActionManager actionService = (ActionManager)Framework.getService(ActionManager.class);
        return this.binaryMetadataComponent.ruleRegistry.contribs.stream().filter(ruleDescriptor -> {
            if (!ruleDescriptor.getEnabled().booleanValue()) {
                return false;
            }
            for (String filterId : ruleDescriptor.getFilterIds()) {
                if (actionService.checkFilter(filterId, actionContext)) continue;
                return false;
            }
            return true;
        }).collect(Collectors.toSet());
    }

    protected ActionContext createActionContext(DocumentModel doc) {
        ELActionContext actionContext = new ELActionContext();
        actionContext.setCurrentDocument(doc);
        return actionContext;
    }

    protected BinaryMetadataProcessor getProcessor(String processorId) throws NoSuchMethodException {
        return this.binaryMetadataComponent.processorRegistry.getProcessor(processorId);
    }

    public List<MetadataMappingDescriptor> getSyncMapping(DocumentModel doc) {
        ActionContext actionContext = this.createActionContext(doc);
        Set<MetadataRuleDescriptor> ruleDescriptors = this.checkFilter(actionContext);
        HashSet<String> syncMappingDescriptorIds = new HashSet<String>();
        HashSet<String> asyncMappingDescriptorIds = new HashSet<String>();
        for (MetadataRuleDescriptor ruleDescriptor : ruleDescriptors) {
            if (ruleDescriptor.getIsAsync().booleanValue()) {
                asyncMappingDescriptorIds.addAll(ruleDescriptor.getMetadataMappingIdDescriptors());
                continue;
            }
            syncMappingDescriptorIds.addAll(ruleDescriptor.getMetadataMappingIdDescriptors());
        }
        if (!asyncMappingDescriptorIds.isEmpty()) {
            doc.putContextData("asyncExecute", (Serializable)Boolean.TRUE);
            doc.putContextData("asyncMappingResult", (Serializable)((Object)this.getMapping(asyncMappingDescriptorIds)));
        }
        if (syncMappingDescriptorIds.isEmpty()) {
            return null;
        }
        return this.getMapping(syncMappingDescriptorIds);
    }

    protected List<MetadataMappingDescriptor> getMapping(Set<String> mappingDescriptorIds) {
        ArrayList<MetadataMappingDescriptor> mappingResult = new ArrayList<MetadataMappingDescriptor>();
        for (String mappingDescriptorId : mappingDescriptorIds) {
            if (!this.binaryMetadataComponent.mappingRegistry.getMappingDescriptorMap().containsKey(mappingDescriptorId)) {
                log.warn((Object)("Missing binary metadata descriptor with id '" + mappingDescriptorId + "'. Or check your rule contribution with proper metadataMapping-id."));
                continue;
            }
            mappingResult.add(this.binaryMetadataComponent.mappingRegistry.getMappingDescriptorMap().get(mappingDescriptorId));
        }
        return mappingResult;
    }

    protected boolean isDirtyMapping(MetadataMappingDescriptor mappingDescriptor, DocumentModel doc) {
        HashMap<String, String> mappingResult = new HashMap<String, String>();
        for (MetadataMappingDescriptor.MetadataDescriptor metadataDescriptor : mappingDescriptor.getMetadataDescriptors()) {
            mappingResult.put(metadataDescriptor.getXpath(), metadataDescriptor.getName());
        }
        HashMap resultDirtyMapping = new HashMap();
        for (String metadata : mappingResult.keySet()) {
            Property property = doc.getProperty(metadata);
            if (!property.isDirty()) continue;
            resultDirtyMapping.put(mappingResult.get(metadata), doc.getPropertyValue(metadata));
        }
        return !resultDirtyMapping.isEmpty();
    }
}

