/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.box.api.file.adapter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;
import org.nuxeo.box.api.adapter.BoxAdapter;
import org.nuxeo.box.api.comment.adapter.BoxCommentAdapter;
import org.nuxeo.box.api.marshalling.dao.BoxCollection;
import org.nuxeo.box.api.marshalling.dao.BoxComment;
import org.nuxeo.box.api.marshalling.dao.BoxFile;
import org.nuxeo.box.api.marshalling.dao.BoxItem;
import org.nuxeo.box.api.marshalling.dao.BoxLock;
import org.nuxeo.box.api.marshalling.dao.BoxUser;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.comment.api.CommentManager;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public class BoxFileAdapter
extends BoxAdapter {
    public BoxFileAdapter(DocumentModel doc) throws ClientException {
        super(doc);
        Blob blob = (Blob)doc.getPropertyValue("file:content");
        if (blob != null) {
            this.boxProperties.put("sha1", blob.getDigest());
        }
        HashMap<String, Object> boxLockProperties = new HashMap<String, Object>();
        Lock lockInfo = doc.getLockInfo();
        if (lockInfo != null) {
            boxLockProperties.put("id", null);
            UserManager userManager = (UserManager)Framework.getLocalService(UserManager.class);
            NuxeoPrincipal lockCreator = userManager.getPrincipal(lockInfo.getOwner());
            BoxUser boxLockCreator = this.boxService.fillUser(lockCreator);
            boxLockProperties.put("created_by", boxLockCreator);
            boxLockProperties.put("created_at", ISODateTimeFormat.dateTime().print((ReadableInstant)new DateTime((Object)lockInfo.getCreated())));
            boxLockProperties.put("expires_at", null);
            boxLockProperties.put("is_download_prevented", false);
            BoxLock boxLock = new BoxLock(boxLockProperties);
            this.boxProperties.put("lock", boxLock);
        }
        this.boxItem = new BoxFile(Collections.unmodifiableMap(this.boxProperties));
    }

    @Override
    public BoxItem getMiniItem() {
        HashMap<String, Object> boxProperties = new HashMap<String, Object>();
        boxProperties.put("id", this.boxItem.getId());
        boxProperties.put("sequence_id", this.boxItem.getSequenceId());
        boxProperties.put("name", this.boxItem.getName());
        boxProperties.put("etag", this.boxItem.getEtag());
        return new BoxFile(boxProperties);
    }

    public BoxCollection getComments() throws ClientException {
        ArrayList<BoxComment> boxComments = new ArrayList<BoxComment>();
        HashMap<String, Serializable> collectionProperties = new HashMap<String, Serializable>();
        CommentManager commentManager = (CommentManager)Framework.getLocalService(CommentManager.class);
        List comments = commentManager.getComments(this.doc);
        for (DocumentModel comment : comments) {
            BoxCommentAdapter boxCommentAdapter = (BoxCommentAdapter)comment.getAdapter(BoxCommentAdapter.class);
            boxComments.add(boxCommentAdapter.getBoxComment());
        }
        collectionProperties.put("entries", boxComments);
        collectionProperties.put("total_count", Integer.valueOf(comments.size()));
        return new BoxCollection(Collections.unmodifiableMap(collectionProperties));
    }
}

