/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.box.api.marshalling.dao;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.nuxeo.box.api.marshalling.interfaces.IBoxType;

public enum BoxResourceType implements IBoxType
{
    ITEM,
    ITEMS,
    FILE,
    FILES,
    WEB_LINK,
    WEB_LINKS,
    PREVIEW,
    FOLDER,
    USER,
    USERS,
    GROUP,
    COMMENT,
    COMMENTS,
    FILE_VERSION,
    FILE_VERSIONS,
    COLLABORATION,
    COLLABORATIONS,
    EMAIL_ALIAS,
    EMAIL_ALIASES,
    OAUTH_DATA,
    ERROR,
    EVENT,
    EVENTS,
    UPDATES,
    REALTIME_SERVER,
    LOCK,
    SERVICE_ACTION,
    ADMIN_SETTINGS,
    LOGIN_TOKEN;

    private static final Map<BoxResourceType, String> typeToLowercaseString;

    @Deprecated
    public static BoxResourceType getTypeFromLowercaseString(String string) {
        return Enum.valueOf(BoxResourceType.class, string.toUpperCase(Locale.US));
    }

    public String toString() {
        return typeToLowercaseString.get(this);
    }

    public String toPluralString() {
        return this.toString() + "s";
    }

    static {
        typeToLowercaseString = new HashMap<BoxResourceType, String>();
        for (BoxResourceType type : BoxResourceType.values()) {
            String str = type.name().toLowerCase(Locale.US);
            typeToLowercaseString.put(type, str);
        }
    }
}

