/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.box.api.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.Response;
import org.nuxeo.box.api.adapter.BoxAdapter;
import org.nuxeo.box.api.folder.adapter.BoxFolderAdapter;
import org.nuxeo.box.api.marshalling.dao.BoxCollaboration;
import org.nuxeo.box.api.marshalling.dao.BoxCollection;
import org.nuxeo.box.api.marshalling.dao.BoxComment;
import org.nuxeo.box.api.marshalling.dao.BoxFile;
import org.nuxeo.box.api.marshalling.dao.BoxFolder;
import org.nuxeo.box.api.marshalling.dao.BoxGroup;
import org.nuxeo.box.api.marshalling.dao.BoxItem;
import org.nuxeo.box.api.marshalling.dao.BoxObject;
import org.nuxeo.box.api.marshalling.dao.BoxTypedObject;
import org.nuxeo.box.api.marshalling.dao.BoxUser;
import org.nuxeo.box.api.marshalling.exceptions.BoxJSONException;
import org.nuxeo.box.api.marshalling.exceptions.BoxRestException;
import org.nuxeo.box.api.marshalling.exceptions.NXBoxJsonException;
import org.nuxeo.box.api.marshalling.jsonparsing.BoxJSONParser;
import org.nuxeo.box.api.marshalling.jsonparsing.BoxResourceHub;
import org.nuxeo.box.api.service.BoxService;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoGroup;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public class BoxServiceImpl
implements BoxService {
    protected final BiMap<String, String> nxBoxRole = HashBiMap.create();

    @Override
    public BiMap<String, String> getNxBoxRole() {
        return this.nxBoxRole;
    }

    public BoxServiceImpl() {
        this.nxBoxRole.put((Object)"Everything", (Object)"editor");
        this.nxBoxRole.put((Object)"Read", (Object)"viewer");
        this.nxBoxRole.put((Object)"Write", (Object)"viewer-uploader");
    }

    @Override
    public BoxCollection searchBox(String term, CoreSession session, String limit, String offset) throws ClientException {
        HashMap<String, Serializable> collectionProperties = new HashMap<String, Serializable>();
        StringBuilder query = new StringBuilder();
        query.append("SELECT * FROM Document where ecm:fulltext = '" + term + "'");
        DocumentModelList documentModels = session.query(query.toString(), null, Long.parseLong(limit), Long.parseLong(offset), false);
        ArrayList<BoxItem> boxDocuments = new ArrayList<BoxItem>();
        for (DocumentModel doc : documentModels) {
            BoxAdapter boxAdapter = (BoxAdapter)doc.getAdapter(BoxAdapter.class);
            boxDocuments.add(boxAdapter.getBoxItem());
        }
        collectionProperties.put("entries", boxDocuments);
        collectionProperties.put("total_count", Integer.valueOf(documentModels.size()));
        return new BoxCollection(Collections.unmodifiableMap(collectionProperties));
    }

    @Override
    public List<BoxTypedObject> getBoxDocumentCollection(DocumentModelList documentModels, String fields) throws ClientException {
        ArrayList<BoxTypedObject> boxObject = new ArrayList<BoxTypedObject>();
        for (DocumentModel documentModel : documentModels) {
            BoxItem boxChild;
            Blob blob;
            HashMap<String, Object> documentProperties = new HashMap<String, Object>();
            documentProperties.put("id", this.getBoxId(documentModel));
            documentProperties.put("sequence_id", this.getBoxSequenceId(documentModel));
            documentProperties.put("etag", this.getBoxEtag(documentModel));
            documentProperties.put("name", this.getBoxName(documentModel));
            if (documentModel.hasSchema("file") && (blob = (Blob)documentModel.getPropertyValue("file:content")) != null) {
                documentProperties.put("sha1", blob.getDigest());
            }
            BoxItem boxItem = boxChild = documentModel.isFolder() ? new BoxFolder() : new BoxFile();
            if (!"*".equals(fields) && fields != null) {
                for (String field : fields.split(",")) {
                    boxChild.put(field, documentProperties.get(field));
                }
            } else {
                boxChild.putAll(documentProperties);
            }
            boxObject.add(boxChild);
        }
        return boxObject;
    }

    @Override
    public BoxCollaboration getBoxCollaboration(BoxFolderAdapter boxFolderAdapter, ACE ace, String collaborationId) throws ClientException {
        HashMap<String, Object> boxCollabProperties = new HashMap<String, Object>();
        boxCollabProperties.put("id", this.computeCollaborationId(boxFolderAdapter.getBoxItem().getId(), collaborationId));
        boxCollabProperties.put("created_at", null);
        boxCollabProperties.put("modified_at", null);
        UserManager userManager = (UserManager)Framework.getLocalService(UserManager.class);
        boxCollabProperties.put("created_by", boxFolderAdapter.getBoxItem().getCreatedBy());
        boxCollabProperties.put("expires_at", null);
        boxCollabProperties.put("status", "active");
        boxCollabProperties.put("acknowledged_at", null);
        boxCollabProperties.put("item", boxFolderAdapter.getMiniItem());
        NuxeoPrincipal user = userManager.getPrincipal(ace.getUsername());
        NuxeoGroup group = userManager.getGroup(ace.getUsername());
        boxCollabProperties.put("accessible_by", user != null ? this.fillUser(user) : this.fillGroup(group));
        boxCollabProperties.put("role", this.nxBoxRole.get((Object)ace.getPermission()));
        return new BoxCollaboration(boxCollabProperties);
    }

    @Override
    public String toJSONString(BoxObject boxObject) throws BoxJSONException {
        BoxJSONParser boxJSONParser = new BoxJSONParser(new BoxResourceHub());
        try {
            return boxObject.toJSONString(boxJSONParser);
        }
        catch (Exception e) {
            throw new BoxRestException("Box Parser Exception", e, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        }
    }

    @Override
    public String getBoxId(DocumentModel doc) {
        if (doc != null) {
            return doc.getName() != null ? doc.getId() : "0";
        }
        return null;
    }

    @Override
    public String getBoxSequenceId(DocumentModel doc) {
        if (doc != null) {
            return doc.getName() != null ? doc.getId() : null;
        }
        return null;
    }

    @Override
    public String getBoxEtag(DocumentModel doc) {
        if (doc != null) {
            return doc.getName() != null ? doc.getId() + "_" + doc.getVersionLabel() : null;
        }
        return null;
    }

    @Override
    public String getBoxName(DocumentModel doc) {
        if (doc != null) {
            return doc.getName() != null ? doc.getName() : "/";
        }
        return null;
    }

    @Override
    public BoxUser fillUser(NuxeoPrincipal creator) {
        HashMap<String, String> mapUser = new HashMap<String, String>();
        mapUser.put("id", creator != null ? creator.getPrincipalId() : "system");
        mapUser.put("name", creator != null ? creator.getFirstName() + " " + creator.getLastName() : "system");
        mapUser.put("login", creator != null ? creator.getName() : "system");
        return new BoxUser(Collections.unmodifiableMap(mapUser));
    }

    @Override
    public BoxGroup fillGroup(NuxeoGroup group) {
        HashMap<String, String> mapGroup = new HashMap<String, String>();
        mapGroup.put("id", group != null ? group.getName() : "system");
        mapGroup.put("name", group != null ? group.getLabel() : "system");
        mapGroup.put("login", group != null ? group.getName() : "system");
        return new BoxGroup(Collections.unmodifiableMap(mapGroup));
    }

    @Override
    public BoxFolder getBoxFolder(String jsonBoxFolder) throws BoxJSONException {
        return new BoxJSONParser(new BoxResourceHub()).parseIntoBoxObject(jsonBoxFolder, BoxFolder.class);
    }

    @Override
    public BoxFile getBoxFile(String jsonBoxFile) throws BoxJSONException {
        return new BoxJSONParser(new BoxResourceHub()).parseIntoBoxObject(jsonBoxFile, BoxFile.class);
    }

    @Override
    public BoxComment getBoxComment(String jsonBoxComment) throws BoxJSONException {
        return new BoxJSONParser(new BoxResourceHub()).parseIntoBoxObject(jsonBoxComment, BoxComment.class);
    }

    @Override
    public BoxCollaboration getBoxCollaboration(String jsonBoxCollaboration) throws BoxJSONException {
        return new BoxJSONParser(new BoxResourceHub()).parseIntoBoxObject(jsonBoxCollaboration, BoxCollaboration.class);
    }

    @Override
    public String getJSONFromBox(BoxTypedObject boxTypedObject) throws BoxJSONException {
        return boxTypedObject.toJSONString(new BoxJSONParser(new BoxResourceHub()));
    }

    @Override
    public String getJSONBoxException(Exception e, int status) {
        NXBoxJsonException boxException = new NXBoxJsonException();
        boxException.setCode(e.getMessage());
        boxException.setMessage(e.getCause() != null ? e.getCause().getMessage() : null);
        boxException.setStatus(status);
        ObjectMapper mapper = new ObjectMapper();
        String jsonExceptionResponse = "";
        try {
            jsonExceptionResponse = mapper.writeValueAsString((Object)boxException);
        }
        catch (JsonProcessingException e1) {
            throw new BoxRestException("error when marshalling server exception:", (Exception)((Object)e1), Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
        }
        return jsonExceptionResponse;
    }

    @Override
    public String[] getCollaborationArrayIds(String collaborationId) {
        String[] collaborationIds = collaborationId.split("-BOX-");
        if (collaborationIds.length == 0) {
            return new String[2];
        }
        return collaborationIds;
    }

    public String computeCollaborationId(String folderId, String collaborationId) {
        return folderId.concat("-BOX-").concat(collaborationId);
    }
}

